/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.central.storage.fs;

import java.util.HashSet;
import java.util.Set;
import net.anotheria.util.StringUtils;

public class IncludeExcludeList {
    private boolean includeAll = false;
    private Set<String> includes = new HashSet<String>();
    private Set<String> excludes = new HashSet<String>();

    public IncludeExcludeList(String include, String exclude) {
        String[] ee;
        String[] ii;
        if (include != null && include.trim().equals("*")) {
            this.includeAll = true;
        }
        if (include == null) {
            include = "";
        }
        if (exclude == null) {
            exclude = "";
        }
        for (String i : ii = StringUtils.tokenize((String)include.trim(), (char)',')) {
            this.includes.add(i.trim());
        }
        for (String e : ee = StringUtils.tokenize((String)exclude.trim(), (char)',')) {
            this.excludes.add(e.trim());
        }
    }

    public Set<String> getIncludes() {
        return this.includes;
    }

    public Set<String> getExcludes() {
        return this.excludes;
    }

    public boolean include(String query) {
        if (this.excludes.contains(query)) {
            return false;
        }
        return this.includeAll || this.includes.contains(query);
    }

    public String toString() {
        return "All: " + this.includeAll + ", incl: " + this.includes + ", excl: " + this.excludes;
    }
}

