/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.central.storage.psql;

import java.util.HashMap;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import net.anotheria.moskito.central.Snapshot;
import net.anotheria.moskito.central.storage.Storage;
import net.anotheria.moskito.central.storage.fs.FileSystemStorage;
import net.anotheria.moskito.central.storage.psql.PSQLStorageConfig;
import net.anotheria.moskito.central.storage.psql.entities.JSONStatisticsEntity;
import net.anotheria.moskito.central.storage.psql.entities.SnapshotEntity;
import net.anotheria.moskito.central.storage.psql.entities.StatisticsEntity;
import org.apache.log4j.Logger;
import org.configureme.ConfigurationManager;

public class PSQLStorage
implements Storage {
    private static final String PERSISTENCE_UNIT_NAME = "snapshotStorage";
    private static Logger log = Logger.getLogger(FileSystemStorage.class);
    private PSQLStorageConfig config;
    private EntityManagerFactory factory;

    @Override
    public void configure(String configurationName) {
        this.config = new PSQLStorageConfig();
        if (configurationName == null) {
            return;
        }
        try {
            ConfigurationManager.INSTANCE.configureAs((Object)this.config, configurationName);
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)("Couldn't configure PSQLStorage with " + configurationName + " , working with default values"));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("javax.persistence.jdbc.driver", this.config.getDriver());
        map.put("javax.persistence.jdbc.url", this.config.getUrl());
        map.put("javax.persistence.jdbc.user", this.config.getUserName());
        map.put("javax.persistence.jdbc.password", this.config.getPassword());
        if (this.config.getHibernateDialect() != null) {
            map.put("hibernate.dialect", this.config.getHibernateDialect());
            map.put("hibernate.hbm2ddl.auto", "create");
            map.put("hibernate.show_sql", "false");
        }
        try {
            this.factory = Persistence.createEntityManagerFactory((String)PERSISTENCE_UNIT_NAME, map);
        }
        catch (PersistenceException e) {
            log.error((Object)("Persistence.createEntityManagerFactory(snapshotStorage, [" + map + "])"), (Throwable)e);
        }
    }

    @Override
    public void processSnapshot(Snapshot target) {
        String interval;
        String producerId = target.getMetaData().getProducerId();
        if (!this.config.include(producerId, interval = target.getMetaData().getIntervalName())) {
            return;
        }
        Class<? extends StatisticsEntity> statEntityClass = this.config.getStatEntityClassName(target.getMetaData().getStatClassName(), producerId);
        if (statEntityClass == null) {
            statEntityClass = JSONStatisticsEntity.class;
        }
        SnapshotEntity entity = new SnapshotEntity();
        entity.setProducerId(producerId);
        entity.setCategory(target.getMetaData().getCategory());
        entity.setSubsystem(target.getMetaData().getSubsystem());
        entity.setIntervalName(interval);
        entity.setComponentName(target.getMetaData().getComponentName());
        entity.setHostName(target.getMetaData().getHostName());
        entity.setCreationTimestamp(target.getMetaData().getCreationTimestamp());
        for (String key : target.getKeySet()) {
            StatisticsEntity entityInstance = null;
            try {
                entityInstance = statEntityClass.newInstance();
            }
            catch (IllegalAccessException e) {
                log.error((Object)"Instance cannot be instantiated", (Throwable)e);
                continue;
            }
            catch (InstantiationException e) {
                log.error((Object)"Instance cannot be instantiated", (Throwable)e);
                continue;
            }
            entityInstance.setStats(target.getStatistics(key));
            entity.addStatistics(key, entityInstance);
        }
        EntityManager manager = this.factory.createEntityManager();
        EntityTransaction tr = manager.getTransaction();
        try {
            tr.begin();
            manager.persist((Object)entity);
            tr.commit();
        }
        catch (Exception e) {
            log.error((Object)"persist failed", (Throwable)e);
            tr.rollback();
        }
    }
}

