/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.central.storage.psql.entities;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import net.anotheria.moskito.central.storage.psql.entities.StatisticsEntity;

@Entity
@Table(name="snapshots")
public class SnapshotEntity
implements Serializable {
    private static final long serialVersionUID = 2299490896666103726L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", unique=true, nullable=false)
    private long snapshotId;
    private String producerId;
    private String componentName;
    private String hostName;
    private String intervalName;
    private long creationTimestamp;
    private long arrivalTimestamp;
    private String category;
    private String subsystem;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private Map<String, StatisticsEntity> statistics = new HashMap<String, StatisticsEntity>();

    public void setStatistics(Map<String, StatisticsEntity> statistics) {
        this.statistics = statistics;
    }

    public Map<String, StatisticsEntity> getStatistics() {
        return this.statistics;
    }

    public void addStatistics(String key, StatisticsEntity value) {
        this.getStatistics().put(key, value);
    }

    public long getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(long snapshotId) {
        this.snapshotId = snapshotId;
    }

    public String getProducerId() {
        return this.producerId;
    }

    public void setProducerId(String producerId) {
        this.producerId = producerId;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getIntervalName() {
        return this.intervalName;
    }

    public void setIntervalName(String intervalName) {
        this.intervalName = intervalName;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public void setCreationTimestamp(long creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public long getArrivalTimestamp() {
        return this.arrivalTimestamp;
    }

    public void setArrivalTimestamp(long arrivalTimestamp) {
        this.arrivalTimestamp = arrivalTimestamp;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getSubsystem() {
        return this.subsystem;
    }

    public void setSubsystem(String subsystem) {
        this.subsystem = subsystem;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.snapshotId ^ this.snapshotId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SnapshotEntity other = (SnapshotEntity)obj;
        return this.snapshotId == other.snapshotId;
    }

    public String toString() {
        return "SnapshotEntity [snapshotId=" + this.snapshotId + ", producerId=" + this.producerId + ", componentName=" + this.componentName + ", hostName=" + this.hostName + ", intervalName=" + this.intervalName + ", creationTimestamp=" + this.creationTimestamp + ", arrivalTimestamp=" + this.arrivalTimestamp + ", category=" + this.category + ", subsystem=" + this.subsystem + ", statistics=" + this.statistics + "]";
    }
}

