/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.central.storage.serializer;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.anotheria.moskito.central.Snapshot;
import net.anotheria.util.NumberUtils;

public class CSVSerializer {
    private ConcurrentMap<String, List<String>> cachedValueNames = new ConcurrentHashMap<String, List<String>>();

    public byte[] serialize(Snapshot snapshot, String stat) {
        List<String> valueNames = this.getValueNames(snapshot);
        Map<String, String> data = snapshot.getStatistics(stat);
        if (data == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        long creationTimestamp = snapshot.getMetaData().getCreationTimestamp();
        for (String s : valueNames) {
            boolean special = false;
            if (ret.length() > 0) {
                ret.append(";");
            }
            if (s.equals("SnapshotTime")) {
                special = true;
                ret.append("\"" + NumberUtils.makeTimeString((long)creationTimestamp) + "\"");
            }
            if (s.equals("SnapshotDate")) {
                special = true;
                ret.append("\"" + NumberUtils.makeDigitalDateStringLong((long)creationTimestamp) + "\"");
            }
            if (s.equals("SnapshotTimestamp")) {
                special = true;
                ret.append("\"" + NumberUtils.makeISO8601TimestampString((long)creationTimestamp) + "\"");
            }
            if (special) continue;
            ret.append("\"" + data.get(s) + "\"");
        }
        try {
            return ret.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 not supported");
        }
    }

    public byte[] getHeader(Snapshot snapshot) {
        List<String> valueNames = this.getValueNames(snapshot);
        StringBuilder ret = new StringBuilder();
        for (String s : valueNames) {
            if (ret.length() > 0) {
                ret.append(";");
            }
            ret.append("\"" + s + "\"");
        }
        try {
            return ret.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 not supported");
        }
    }

    private List<String> getValueNames(Snapshot snapshot) {
        ArrayList<Object> valueNames = (ArrayList<Object>)this.cachedValueNames.get(snapshot.getMetaData().getProducerId());
        if (valueNames != null) {
            return valueNames;
        }
        valueNames = new ArrayList<Object>();
        Set<Map.Entry<String, HashMap<String, String>>> entries = snapshot.getEntrySet();
        if (entries.size() == 0) {
            List old = this.cachedValueNames.putIfAbsent(snapshot.getMetaData().getProducerId(), valueNames);
            return old == null ? valueNames : old;
        }
        Map oneStat = entries.iterator().next().getValue();
        valueNames.addAll(oneStat.keySet());
        Collections.sort(valueNames);
        valueNames.add(0, "SnapshotTime");
        valueNames.add(0, "SnapshotDate");
        valueNames.add(0, "SnapshotTimestamp");
        List old = this.cachedValueNames.putIfAbsent(snapshot.getMetaData().getProducerId(), valueNames);
        return old == null ? valueNames : old;
    }
}

