/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskitominimal.listeners;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import net.anotheria.moskito.core.threshold.ThresholdConditionGuard;
import net.anotheria.moskito.core.threshold.ThresholdStatus;
import net.anotheria.moskito.core.threshold.Thresholds;
import net.anotheria.moskito.core.threshold.guard.GuardedDirection;
import net.anotheria.moskito.core.threshold.guard.LongBarrierPassGuard;

public class SetupThresholds
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
        System.out.println("Configuring thresholds ... ");
        this.setupMemory();
        this.setupThreadCount();
        System.out.println(" ... done.");
    }

    private void setupMemory() {
        this.setupMemoryThreshold("PermGenFree", "MemoryPool-PS Perm Gen-NonHeap", "Free", new ThresholdConditionGuard[]{new LongBarrierPassGuard(ThresholdStatus.GREEN, 5000000L, GuardedDirection.UP), new LongBarrierPassGuard(ThresholdStatus.YELLOW, 5000000L, GuardedDirection.DOWN), new LongBarrierPassGuard(ThresholdStatus.ORANGE, 2000000L, GuardedDirection.DOWN), new LongBarrierPassGuard(ThresholdStatus.RED, 1000000L, GuardedDirection.DOWN), new LongBarrierPassGuard(ThresholdStatus.PURPLE, 1000L, GuardedDirection.DOWN)});
        this.setupMemoryThreshold("OldGenFree", "MemoryPool-PS Old Gen-Heap", "Free", new ThresholdConditionGuard[]{new LongBarrierPassGuard(ThresholdStatus.GREEN, 100000000L, GuardedDirection.UP), new LongBarrierPassGuard(ThresholdStatus.YELLOW, 50000000L, GuardedDirection.DOWN), new LongBarrierPassGuard(ThresholdStatus.ORANGE, 10000000L, GuardedDirection.DOWN), new LongBarrierPassGuard(ThresholdStatus.RED, 2000000L, GuardedDirection.DOWN), new LongBarrierPassGuard(ThresholdStatus.PURPLE, 1000000L, GuardedDirection.DOWN)});
    }

    private void setupMemoryThreshold(String name, String producerName, String valueName, ThresholdConditionGuard ... guards) {
        Thresholds.addMemoryThreshold((String)name, (String)producerName, (String)valueName, (ThresholdConditionGuard[])guards);
    }

    private void setupUrlAVG(String name, String url, ThresholdConditionGuard ... guards) {
        Thresholds.addUrlAVGThreshold((String)name, (String)url, (ThresholdConditionGuard[])guards);
    }

    private void setupThreadCount() {
        Thresholds.addThreshold((String)"ThreadCount", (String)"ThreadCount", (String)"ThreadCount", (String)"Current", (String)"default", (ThresholdConditionGuard[])new ThresholdConditionGuard[]{new LongBarrierPassGuard(ThresholdStatus.GREEN, 200L, GuardedDirection.DOWN), new LongBarrierPassGuard(ThresholdStatus.YELLOW, 200L, GuardedDirection.UP), new LongBarrierPassGuard(ThresholdStatus.ORANGE, 300L, GuardedDirection.UP), new LongBarrierPassGuard(ThresholdStatus.RED, 500L, GuardedDirection.UP), new LongBarrierPassGuard(ThresholdStatus.PURPLE, 1000L, GuardedDirection.UP)});
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

