/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.extension.mongodb;

import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoDatabase;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.anotheria.moskito.core.dynamic.IOnDemandStatsFactory;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducer;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducerException;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.extension.mongodb.MongodbStats;
import net.anotheria.moskito.extension.mongodb.MongodbStatsFactory;
import net.anotheria.moskito.extension.mongodb.config.MongodbMonitorConfig;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongodbMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongodbMonitor.class);
    private static final String DB_ADMIN = "admin";
    private MongoClient mongoClient;
    private static OnDemandStatsProducer<MongodbStats> producer;

    public MongodbMonitor() {
        producer = new OnDemandStatsProducer("MongoMonitor", "Monitor", "db", (IOnDemandStatsFactory)new MongodbStatsFactory());
        ProducerRegistryFactory.getProducerRegistryInstance().registerProducer(producer);
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(new UpdateTask(), 0L, MongodbMonitorConfig.getInstance().getUpdatePeriod(), TimeUnit.MINUTES);
    }

    public void updateStats() {
        try {
            this.mongoClient = this.createClient(MongodbMonitorConfig.getInstance());
            MongoDatabase adminDb = this.mongoClient.getDatabase(DB_ADMIN);
            this.updateMongoServerStats(adminDb);
        }
        finally {
            if (this.mongoClient != null) {
                this.mongoClient.close();
            }
        }
    }

    private MongoClient createClient(MongodbMonitorConfig config) {
        List<MongoCredential> mongoCredentials = this.createMongoCredentials(config);
        if (mongoCredentials.size() == 0) {
            return new MongoClient(config.getHost(), Integer.parseInt(config.getPort()));
        }
        return new MongoClient(new ServerAddress(config.getHost(), Integer.parseInt(config.getPort())), mongoCredentials);
    }

    private List<MongoCredential> createMongoCredentials(MongodbMonitorConfig config) {
        if (config.getLogin() == null) {
            return new ArrayList<MongoCredential>(0);
        }
        ArrayList<MongoCredential> mongoCredentials = new ArrayList<MongoCredential>(1);
        mongoCredentials.add(MongoCredential.createCredential((String)config.getLogin(), (String)config.getDbName(), (char[])config.getPassword().toCharArray()));
        return mongoCredentials;
    }

    private void updateMongoServerStats(MongoDatabase dbAdmin) {
        DBObject serverStats = this.executeMongoCommand(dbAdmin, "serverStatus");
        Map map = serverStats.toMap();
        this.updateFlushing(map);
        this.updateConnections(map);
    }

    private void updateFlushing(Map<String, Object> map) {
        Map backgroundFlushing = (Map)map.get("backgroundFlushing");
        MongodbStats stats = this.getProducerStats();
        stats.getFlushes().setValueAsInt(((Integer)backgroundFlushing.get("flushes")).intValue());
        stats.getTotal_ms_write().setValueAsInt(((Integer)backgroundFlushing.get("total_ms")).intValue());
        stats.getAvg_ms_write().setValueAsDouble(((Double)backgroundFlushing.get("average_ms")).doubleValue());
        stats.getLast_ms_write().setValueAsInt(((Integer)backgroundFlushing.get("last_ms")).intValue());
    }

    private void updateConnections(Map<String, Object> map) {
        Map connections = (Map)map.get("connections");
        MongodbStats stats = this.getProducerStats();
        stats.getCurrent_connections().setValueAsInt(((Integer)connections.get("current")).intValue());
        stats.getAvailable_connections().setValueAsInt(((Integer)connections.get("available")).intValue());
        stats.getTotal_created_connections().setValueAsInt(((Integer)connections.get("totalCreated")).intValue());
    }

    private MongodbStats getProducerStats() {
        try {
            return (MongodbStats)producer.getStats("cumulated");
        }
        catch (OnDemandStatsProducerException e) {
            throw new IllegalStateException(e);
        }
    }

    private DBObject executeMongoCommand(MongoDatabase db, String command) {
        DBObject dbObject = null;
        try {
            dbObject = (DBObject)JSON.parse((String)db.runCommand((Bson)new Document(command, (Object)1)).toJson());
        }
        catch (MongoCommandException e) {
            LOGGER.error("Couldn't execute mongo command", (Throwable)e);
        }
        return dbObject;
    }

    public static MongodbMonitor createMongodbMonitor() {
        return new MongodbMonitor();
    }

    public static void destroyMongodbMonitor() {
        ProducerRegistryFactory.getProducerRegistryInstance().unregisterProducer(producer);
    }

    private class UpdateTask
    implements Runnable {
        private UpdateTask() {
        }

        @Override
        public void run() {
            MongodbMonitor.this.updateStats();
        }
    }
}

