/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.extension.mongodb;

import net.anotheria.moskito.core.decorators.DecoratorRegistryFactory;
import net.anotheria.moskito.core.decorators.IDecorator;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.AbstractStats;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;
import net.anotheria.moskito.core.util.MoskitoWebUi;
import net.anotheria.moskito.extension.mongodb.decorator.MongodbStatsDecorator;
import net.anotheria.util.StringUtils;

public class MongodbStats
extends AbstractStats {
    private StatValue flushes = this.newIntStatValue(MongoStatsFields.FLUSHES.toString());
    private StatValue total_ms_write = this.newIntStatValue(MongoStatsFields.TOTAL_MS_WRITE.toString());
    private StatValue avg_ms_write = this.newDoubleStatValue(MongoStatsFields.AVG_MS_WRITE.toString());
    private StatValue last_ms_write = this.newIntStatValue(MongoStatsFields.LAST_MS_WRITE.toString());
    private StatValue current_connections = this.newIntStatValue(MongoStatsFields.CURRENT_CONNECTIONS.toString());
    private StatValue available_connections = this.newIntStatValue(MongoStatsFields.AVAIlABLE_CONNECTIONS.toString());
    private StatValue total_created_connections = this.newIntStatValue(MongoStatsFields.TOTAL_CREATED_CONNECTIONS.toString());

    public MongodbStats(String aName) {
        super(aName);
    }

    public StatValue getFlushes() {
        return this.flushes;
    }

    public void setFlushes(StatValue flushes) {
        this.flushes = flushes;
    }

    public StatValue getTotal_ms_write() {
        return this.total_ms_write;
    }

    public void setTotal_ms_write(StatValue total_ms_write) {
        this.total_ms_write = total_ms_write;
    }

    public StatValue getAvg_ms_write() {
        return this.avg_ms_write;
    }

    public void setAvg_ms_write(StatValue avg_ms_write) {
        this.avg_ms_write = avg_ms_write;
    }

    public StatValue getLast_ms_write() {
        return this.last_ms_write;
    }

    public void setLast_ms_write(StatValue last_ms_write) {
        this.last_ms_write = last_ms_write;
    }

    public StatValue getCurrent_connections() {
        return this.current_connections;
    }

    public void setCurrent_connections(StatValue current_connections) {
        this.current_connections = current_connections;
    }

    public StatValue getAvailable_connections() {
        return this.available_connections;
    }

    public void setAvailable_connections(StatValue available_connections) {
        this.available_connections = available_connections;
    }

    public StatValue getTotal_created_connections() {
        return this.total_created_connections;
    }

    public void setTotal_created_connections(StatValue total_created_connections) {
        this.total_created_connections = total_created_connections;
    }

    private StatValue newIntStatValue(String valueName) {
        StatValue sv = StatValueFactory.createStatValue((Object)0, (String)valueName, (Interval[])Constants.getDefaultIntervals());
        this.addStatValues(new StatValue[]{sv});
        return sv;
    }

    private StatValue newDoubleStatValue(String valueName) {
        StatValue sv = StatValueFactory.createStatValue((Object)0.0, (String)valueName, (Interval[])Constants.getDefaultIntervals());
        this.addStatValues(new StatValue[]{sv});
        return sv;
    }

    public String getValueByNameAsString(String valueName, String intervalName, TimeUnit timeUnit) {
        if (StringUtils.isEmpty((String)valueName)) {
            throw new AssertionError((Object)"Value name can not be null or empty");
        }
        if (valueName.equals(MongoStatsFields.FLUSHES.toString())) {
            return this.getFlushes().getValueAsString(intervalName);
        }
        if (valueName.equals(MongoStatsFields.TOTAL_MS_WRITE.toString())) {
            return String.valueOf(timeUnit.transformMillis(this.getTotal_ms_write().getValueAsLong(intervalName)));
        }
        if (valueName.equals(MongoStatsFields.AVG_MS_WRITE.toString())) {
            return String.valueOf(timeUnit.transformMillis(this.getAvg_ms_write().getValueAsDouble(intervalName)));
        }
        if (valueName.equals(MongoStatsFields.LAST_MS_WRITE.toString())) {
            return String.valueOf(timeUnit.transformMillis(this.getLast_ms_write().getValueAsDouble(intervalName)));
        }
        if (valueName.equals(MongoStatsFields.CURRENT_CONNECTIONS.toString())) {
            return this.getCurrent_connections().getValueAsString(intervalName);
        }
        if (valueName.equals(MongoStatsFields.AVAIlABLE_CONNECTIONS.toString())) {
            return this.getAvailable_connections().getValueAsString(intervalName);
        }
        if (valueName.equals(MongoStatsFields.TOTAL_CREATED_CONNECTIONS.toString())) {
            return this.getTotal_created_connections().getValueAsString(intervalName);
        }
        return super.getValueByNameAsString(valueName, intervalName, timeUnit);
    }

    public String toStatsString(String aIntervalName, TimeUnit unit) {
        StringBuilder sb = new StringBuilder("MongodbStats{");
        sb.append("flushes=").append(this.flushes.getValueAsString(aIntervalName));
        sb.append(", total_ms_write=").append(this.total_ms_write.getValueAsString(aIntervalName));
        sb.append(", avg_ms_write=").append(this.avg_ms_write.getValueAsString(aIntervalName));
        sb.append(", last_ms_write=").append(this.last_ms_write.getValueAsString(aIntervalName));
        sb.append(", current_connections=").append(this.current_connections.getValueAsString(aIntervalName));
        sb.append(", available_connections=").append(this.available_connections.getValueAsString(aIntervalName));
        sb.append(", total_created_connections=").append(this.total_created_connections.getValueAsString(aIntervalName));
        sb.append('}');
        return sb.toString();
    }

    static {
        if (MoskitoWebUi.isPresent()) {
            new StatsDecoratorRegistrator().register();
        }
    }

    private static enum MongoStatsFields {
        FLUSHES("flushes"),
        TOTAL_MS_WRITE("totalMsWrite"),
        AVG_MS_WRITE("avgMsWrite"),
        LAST_MS_WRITE("lastMsWrite"),
        CURRENT_CONNECTIONS("currentConnections"),
        AVAIlABLE_CONNECTIONS("availableConnections"),
        TOTAL_CREATED_CONNECTIONS("totalCreatedConnections");

        private String fieldName;

        private MongoStatsFields(String fieldName) {
            this.fieldName = fieldName;
        }

        public String toString() {
            return this.fieldName;
        }
    }

    private static final class StatsDecoratorRegistrator {
        private StatsDecoratorRegistrator() {
        }

        public void register() {
            DecoratorRegistryFactory.getDecoratorRegistry().addDecorator(MongodbStats.class, (IDecorator)new MongodbStatsDecorator());
        }
    }
}

