/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.extension.mongodb.config;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.configureme.ConfigurationManager;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigureMe(name="mongodb-monitor")
public class MongodbMonitorConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongodbMonitorConfig.class);
    private static Lock lock = new ReentrantLock();
    private static MongodbMonitorConfig INSTANCE;
    @Configure
    private String host = "localhost";
    @Configure
    private String port = "27017";
    @Configure
    private String dbName = "admin";
    @Configure
    private String login;
    @Configure
    private String password;
    @Configure
    private String collectionName;
    @Configure
    private long updatePeriod = 60000L;

    private MongodbMonitorConfig() {
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public long getUpdatePeriod() {
        return this.updatePeriod;
    }

    public void setUpdatePeriod(long updatePeriod) {
        this.updatePeriod = updatePeriod;
    }

    public static MongodbMonitorConfig getInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        lock.lock();
        INSTANCE = new MongodbMonitorConfig();
        try {
            ConfigurationManager.INSTANCE.configure((Object)INSTANCE);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Can't configure mongodb monitor, working with defaults", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        return INSTANCE;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MongodbMonitorConfig{");
        sb.append("host='").append(this.host).append('\'');
        sb.append(", port='").append(this.port).append('\'');
        sb.append(", dbName='").append(this.dbName).append('\'');
        sb.append(", login='").append(this.login).append('\'');
        sb.append(", password='").append(this.password).append('\'');
        sb.append(", collectionName='").append(this.collectionName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

