/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.extensions.sampling;

import net.anotheria.moskito.core.dynamic.OnDemandStatsProducer;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducerException;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.IProducerRegistry;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.extensions.sampling.Sample;
import net.anotheria.moskito.extensions.sampling.StatsMapper;
import net.anotheria.moskito.extensions.sampling.mappers.ServiceRequestStatsMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamplingEngine {
    private static final Logger log = LoggerFactory.getLogger(SamplingEngine.class);
    private static final SamplingEngine instance = new SamplingEngine();
    private final IProducerRegistry producerRegistry = ProducerRegistryFactory.getProducerRegistryInstance();
    public static final Boolean FLAG_REGISTER_PRODUCER_ON_THE_FLY = Boolean.TRUE;

    private SamplingEngine() {
    }

    public static final SamplingEngine getInstance() {
        return instance;
    }

    public void addSample(Sample sample) {
        this.processSample(sample);
    }

    private void processSample(Sample sample) {
        String producerId = sample.getProducerId();
        String mapperId = sample.getStatMapperId();
        StatsMapper mapper = this.getMapper(mapperId);
        if (mapper == null) {
            log.error("Mapper with id " + mapperId + " not found, thrown away sample " + sample);
            return;
        }
        OnDemandStatsProducer producer = (OnDemandStatsProducer)this.producerRegistry.getProducer(producerId);
        if (producer == null) {
            String subsystem;
            if (!FLAG_REGISTER_PRODUCER_ON_THE_FLY.booleanValue()) {
                log.warn("Submitted new sample for " + producerId + ", which is not registered and producer auto-register is off");
                return;
            }
            log.info("Registering producer " + producerId + " on the fly");
            String category = sample.getValues().get("category");
            if (category == null) {
                category = "sampling";
            }
            if ((subsystem = sample.getValues().get("subsystem")) == null) {
                subsystem = "sampling";
            }
            producer = new OnDemandStatsProducer(producerId, category, subsystem, mapper.getFactory());
            this.producerRegistry.registerProducer((IStatsProducer)producer);
        }
        log.debug("Have to add sampling value to producer " + producer);
        String statName = sample.getValues().get("stat");
        IStats defaultStats = producer.getDefaultStats();
        mapper.updateStats(defaultStats, sample);
        try {
            IStats stats = producer.getStats(statName);
            mapper.updateStats(stats, sample);
        }
        catch (OnDemandStatsProducerException e) {
            log.warn("Can't create new stats object", (Throwable)e);
        }
    }

    private StatsMapper getMapper(String mapperId) {
        if (mapperId.equals("servicerequest")) {
            return new ServiceRequestStatsMapper();
        }
        return null;
    }
}

