/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.extensions.sampling.endpoints.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import net.anotheria.moskito.extensions.sampling.Sample;
import net.anotheria.moskito.extensions.sampling.SamplingEngine;
import net.anotheria.moskito.web.MoskitoHttpServlet;

@WebServlet(urlPatterns={"/sampling/sample"})
public class SamplingServlet
extends MoskitoHttpServlet {
    private static final long serialVersionUID = -3131209799814451746L;
    public static final String PARAM_PRODUCER_ID = "id";
    public static final String PARAM_STAT_MAPPER_ID = "mapper";
    private SamplingEngine engine;

    public void init() throws ServletException {
        super.init();
        this.engine = SamplingEngine.getInstance();
    }

    protected void moskitoDoGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String producerId = req.getParameter(PARAM_PRODUCER_ID);
        if (producerId == null || producerId.length() == 0) {
            throw new IllegalArgumentException("ProducerId parameter 'id' may not be empty.");
        }
        String mapperId = req.getParameter(PARAM_STAT_MAPPER_ID);
        if (mapperId == null || mapperId.length() == 0) {
            throw new IllegalArgumentException("mapperId parameter 'mapper' may not be empty.");
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        Enumeration paramNames = req.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String pName = (String)paramNames.nextElement();
            if (pName.equals(PARAM_PRODUCER_ID) || pName.equals(PARAM_STAT_MAPPER_ID)) continue;
            parameters.put(pName.toLowerCase(), req.getParameter(pName));
        }
        Sample sample = new Sample();
        sample.setProducerId(producerId);
        sample.setStatMapperId(mapperId);
        sample.setValues(parameters);
        this.engine.addSample(sample);
    }
}

