/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.extensions.tomcat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TimerTask;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidApplicationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.util.BuiltinUpdater;
import net.anotheria.moskito.extensions.tomcat.GlobalRequestProcessorStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalRequestProcessorProducer
implements IStatsProducer {
    private static final String[] ATTRIBUTE_NAMES = new String[]{"requestCount", "maxTime", "bytesReceived", "bytesSent", "processingTime", "errorCount"};
    private List<IStats> iStats;
    private ObjectInstance mBean;
    private MBeanServer mBeanServer;
    private static final Logger log = LoggerFactory.getLogger(GlobalRequestProcessorProducer.class);

    public GlobalRequestProcessorProducer() {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        for (MBeanServer s : servers) {
            Set<ObjectInstance> instances = s.queryMBeans(null, new QueryExp(){

                @Override
                public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
                    String type = name.getKeyProperty("type");
                    return name.getDomain().equals("Catalina") && type.equals("GlobalRequestProcessor");
                }

                @Override
                public void setMBeanServer(MBeanServer s) {
                }
            });
            if (instances.size() == 0) continue;
            this.mBean = instances.iterator().next();
            this.mBeanServer = s;
            this.iStats = new ArrayList<IStats>(1);
            this.iStats.add((IStats)new GlobalRequestProcessorStats());
            break;
        }
        BuiltinUpdater.addTask((TimerTask)new TimerTask(){

            @Override
            public void run() {
                GlobalRequestProcessorProducer.this.readAttributes();
            }
        });
    }

    public String getCategory() {
        return "mBean";
    }

    public String getSubsystem() {
        return "tomcat";
    }

    public String getProducerId() {
        return "GlobalRequestProcessor";
    }

    public List<IStats> getStats() {
        return this.iStats;
    }

    private void readAttributes() {
        try {
            AttributeList attributeList = this.mBeanServer.getAttributes(this.mBean.getObjectName(), ATTRIBUTE_NAMES);
            if (attributeList.size() != ATTRIBUTE_NAMES.length) {
                log.error("Failed to read GlobalRequestProcessor mbean attributes: " + attributeList.asList().toString());
                return;
            }
            HashMap<String, Long> attributesMap = new HashMap<String, Long>();
            for (Attribute attribute : attributeList.asList()) {
                attributesMap.put(attribute.getName(), Long.valueOf(attribute.getValue().toString()));
            }
            ((GlobalRequestProcessorStats)this.iStats.get(0)).update((Long)attributesMap.get(ATTRIBUTE_NAMES[0]), (Long)attributesMap.get(ATTRIBUTE_NAMES[1]), (Long)attributesMap.get(ATTRIBUTE_NAMES[2]), (Long)attributesMap.get(ATTRIBUTE_NAMES[3]), (Long)attributesMap.get(ATTRIBUTE_NAMES[4]), (Long)attributesMap.get(ATTRIBUTE_NAMES[5]));
        }
        catch (InstanceNotFoundException | ReflectionException e) {
            log.error("Failed to read GlobalRequestProcessor mbean attributes ", (Throwable)e);
        }
    }
}

