/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.extensions.tomcat;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.anotheria.moskito.core.decorators.DecoratorRegistryFactory;
import net.anotheria.moskito.core.decorators.IDecorator;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.AbstractStats;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.StatValueTypes;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;
import net.anotheria.moskito.core.util.MoskitoWebUi;
import net.anotheria.moskito.extensions.tomcat.GlobalRequestProcessorStatsDecorator;

public class GlobalRequestProcessorStats
extends AbstractStats {
    private static final String NAME = "GlobalRequestProcessor";
    private final StatValue requestCount;
    private final StatValue maxTime;
    private final StatValue bytesReceived;
    private final StatValue bytesSent;
    private final StatValue processingTime;
    private final StatValue errorCount;
    private static final List<String> VALUE_NAMES;

    public GlobalRequestProcessorStats() {
        this(Constants.getDefaultIntervals());
    }

    private GlobalRequestProcessorStats(Interval[] selectedIntervals) {
        super(NAME);
        this.requestCount = StatValueFactory.createStatValue((StatValueTypes)StatValueTypes.DIFFLONG, (String)"requestCount", (Interval[])selectedIntervals);
        this.maxTime = StatValueFactory.createStatValue((StatValueTypes)StatValueTypes.DIFFLONG, (String)"maxTime", (Interval[])selectedIntervals);
        this.bytesReceived = StatValueFactory.createStatValue((StatValueTypes)StatValueTypes.DIFFLONG, (String)"bytesReceived", (Interval[])selectedIntervals);
        this.bytesSent = StatValueFactory.createStatValue((StatValueTypes)StatValueTypes.DIFFLONG, (String)"bytesSent", (Interval[])selectedIntervals);
        this.processingTime = StatValueFactory.createStatValue((StatValueTypes)StatValueTypes.DIFFLONG, (String)"processingTime", (Interval[])selectedIntervals);
        this.errorCount = StatValueFactory.createStatValue((StatValueTypes)StatValueTypes.DIFFLONG, (String)"errorCount", (Interval[])selectedIntervals);
        this.addStatValues(new StatValue[]{this.requestCount, this.maxTime, this.bytesReceived, this.bytesSent, this.processingTime, this.errorCount});
    }

    public String toStatsString(String intervalName, TimeUnit unit) {
        StringBuilder ret = new StringBuilder();
        ret.append(this.getName()).append(' ');
        ret.append(" RequestCount: ").append(this.requestCount.getValueAsLong(intervalName));
        ret.append(" MaxTime: ").append(this.maxTime.getValueAsLong(intervalName));
        ret.append(" BytesReceived: ").append(this.bytesReceived.getValueAsLong(intervalName));
        ret.append(" BytesSent: ").append(this.bytesSent.getValueAsLong(intervalName));
        ret.append(" ProcessingTime: ").append(this.processingTime.getValueAsLong(intervalName));
        ret.append(" ErrorCount: ").append(this.errorCount.getValueAsLong(intervalName));
        return ret.toString();
    }

    public String getValueByNameAsString(String valueName, String intervalName, TimeUnit timeUnit) {
        if (valueName == null) {
            throw new AssertionError((Object)"Value name can't be null");
        }
        if ((valueName = valueName.toLowerCase()).equals("requestcount") || valueName.equals("request count")) {
            return String.valueOf(this.getRequestCount(intervalName));
        }
        if (valueName.equals("maxtime") || valueName.equals("max time")) {
            return String.valueOf(this.getMaxTime(intervalName));
        }
        if (valueName.equals("bytesreceived") || valueName.equals("bytes received")) {
            return String.valueOf(this.getBytesReceived(intervalName));
        }
        if (valueName.equals("bytessent") || valueName.equals("bytes sent")) {
            return String.valueOf(this.getBytesSent(intervalName));
        }
        if (valueName.equals("processingtime") || valueName.equals("processing time")) {
            return String.valueOf(this.getProcessingTime(intervalName));
        }
        if (valueName.equals("errorcount") || valueName.equals("error count")) {
            return String.valueOf(this.getErrorCount(intervalName));
        }
        return super.getValueByNameAsString(valueName, intervalName, timeUnit);
    }

    public List<String> getAvailableValueNames() {
        return VALUE_NAMES;
    }

    public void update(long aRequestCount, long aMaxTime, long aBytesReceived, long aBytesSent, long aProcessingTime, long aErrorCount) {
        this.requestCount.setValueAsLong(aRequestCount);
        this.maxTime.setValueAsLong(aMaxTime);
        this.bytesReceived.setValueAsLong(aBytesReceived);
        this.bytesSent.setValueAsLong(aBytesSent);
        this.processingTime.setValueAsLong(aProcessingTime);
        this.errorCount.setValueAsLong(aErrorCount);
    }

    public long getRequestCount(String intervalName) {
        return this.requestCount.getValueAsLong(intervalName);
    }

    public long getMaxTime(String intervalName) {
        return this.maxTime.getValueAsLong(intervalName);
    }

    public long getBytesReceived(String intervalName) {
        return this.bytesReceived.getValueAsLong(intervalName);
    }

    public long getBytesSent(String intervalName) {
        return this.bytesSent.getValueAsLong(intervalName);
    }

    public long getProcessingTime(String intervalName) {
        return this.processingTime.getValueAsLong(intervalName);
    }

    public long getErrorCount(String intervalName) {
        return this.errorCount.getValueAsLong(intervalName);
    }

    static {
        if (MoskitoWebUi.isPresent()) {
            DecoratorRegistryFactory.getDecoratorRegistry().addDecorator(GlobalRequestProcessorStats.class, (IDecorator)new GlobalRequestProcessorStatsDecorator());
        }
        VALUE_NAMES = Collections.unmodifiableList(Arrays.asList("RequestCount", "MaxTime", "BytesReceived", "BytesSent", "ProcessingTime", "ErrorCount"));
    }
}

