/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.anotheria.moskito.core.dynamic.EntryCountLimitedOnDemandStatsProducer;
import net.anotheria.moskito.core.dynamic.IOnDemandStatsFactory;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducer;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducerException;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.predefined.FilterStats;
import net.anotheria.moskito.core.predefined.FilterStatsFactory;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.core.stats.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MoskitoFilter
implements Filter {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String INIT_PARAM_LIMIT = "limit";
    public static final String OTHER = "-other-";
    private FilterStats otherStats = null;
    private OnDemandStatsProducer<FilterStats> onDemandProducer;

    protected MoskitoFilter() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (this.onDemandProducer == null) {
            this.log.error("Access to filter before it's inited!");
            chain.doFilter(req, res);
            return;
        }
        FilterStats defaultStats = (FilterStats)this.onDemandProducer.getDefaultStats();
        FilterStats caseStats = null;
        String caseName = this.extractCaseName(req, res);
        try {
            if (caseName != null) {
                caseStats = (FilterStats)this.onDemandProducer.getStats(caseName);
            }
        }
        catch (OnDemandStatsProducerException e) {
            this.log.info("Couldn't get stats for case : " + caseName + ", probably limit reached");
            caseStats = this.otherStats;
        }
        defaultStats.addRequest();
        if (caseStats != null) {
            caseStats.addRequest();
        }
        try {
            long startTime = System.nanoTime();
            chain.doFilter(req, res);
            long exTime = System.nanoTime() - startTime;
            defaultStats.addExecutionTime(exTime);
            if (caseStats != null) {
                caseStats.addExecutionTime(exTime);
            }
        }
        catch (ServletException e) {
            defaultStats.notifyServletException((Throwable)e);
            if (caseStats != null) {
                caseStats.notifyServletException((Throwable)e);
            }
            throw e;
        }
        catch (IOException e) {
            defaultStats.notifyIOException((Throwable)e);
            if (caseStats != null) {
                caseStats.notifyIOException((Throwable)e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            defaultStats.notifyRuntimeException((Throwable)e);
            if (caseStats != null) {
                caseStats.notifyRuntimeException((Throwable)e);
            }
            throw e;
        }
        catch (Error e) {
            defaultStats.notifyError((Throwable)e);
            if (caseStats != null) {
                caseStats.notifyError();
            }
            throw e;
        }
        finally {
            defaultStats.notifyRequestFinished();
            if (caseStats != null) {
                caseStats.notifyRequestFinished();
            }
        }
    }

    public void init(FilterConfig config) throws ServletException {
        int limit = -1;
        String pLimit = config.getInitParameter(INIT_PARAM_LIMIT);
        if (pLimit != null) {
            try {
                limit = Integer.parseInt(pLimit);
            }
            catch (NumberFormatException ignored) {
                this.log.warn("couldn't parse limit \"" + pLimit + "\", assume -1 aka no limit.");
            }
        }
        this.onDemandProducer = limit == -1 ? new OnDemandStatsProducer(this.getProducerId(), this.getCategory(), this.getSubsystem(), (IOnDemandStatsFactory)new FilterStatsFactory(this.getMonitoringIntervals())) : new EntryCountLimitedOnDemandStatsProducer(this.getProducerId(), this.getCategory(), this.getSubsystem(), (IOnDemandStatsFactory)new FilterStatsFactory(this.getMonitoringIntervals()), limit);
        ProducerRegistryFactory.getProducerRegistryInstance().registerProducer(this.onDemandProducer);
        try {
            if (limit != -1) {
                this.otherStats = (FilterStats)this.onDemandProducer.getStats(OTHER);
            }
        }
        catch (OnDemandStatsProducerException e) {
            this.log.error("Can't create default stats for limit excess", (Throwable)e);
        }
    }

    public void destroy() {
    }

    protected abstract String extractCaseName(ServletRequest var1, ServletResponse var2);

    public String getProducerId() {
        return this.getClass().getSimpleName();
    }

    protected String getCategory() {
        return "filter";
    }

    protected String getSubsystem() {
        return "default";
    }

    protected Interval[] getMonitoringIntervals() {
        return Constants.getDefaultIntervals();
    }

    protected OnDemandStatsProducer<FilterStats> getProducer() {
        return this.onDemandProducer;
    }

    protected FilterStats getOtherStats() {
        return this.otherStats;
    }
}

