/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.web.filters;

import java.io.IOException;
import java.net.InetAddress;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducer;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducerException;
import net.anotheria.moskito.core.predefined.FilterStats;
import net.anotheria.moskito.web.MoskitoFilter;
import net.anotheria.util.queue.IQueueWorker;
import net.anotheria.util.queue.QueuedProcessor;
import net.anotheria.util.queue.UnrecoverableQueueOverflowException;

public class AsyncSourceTldFilter
extends MoskitoFilter {
    public static final int TLD_LENGTH_LIMIT = 20;
    private QueuedProcessor<TemporaryStatsStorage> asyncProcessor;

    @Override
    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        this.asyncProcessor = new QueuedProcessor("async-tld-resolver", (IQueueWorker)new QueueWorker(this), 10000, this.log);
        this.asyncProcessor.start();
    }

    private void writeStatsToProducer(String caseName, TemporaryStatsStorage tss) {
        OnDemandStatsProducer<FilterStats> onDemandProducer = this.getProducer();
        FilterStats defaultStats = (FilterStats)onDemandProducer.getDefaultStats();
        FilterStats caseStats = null;
        try {
            if (caseName != null) {
                caseStats = (FilterStats)onDemandProducer.getStats(caseName);
            }
        }
        catch (OnDemandStatsProducerException e) {
            this.log.info("Couldn't get stats for case : " + caseName + ", probably limit reached");
            caseStats = this.getOtherStats();
        }
        defaultStats.addRequest();
        if (caseStats != null) {
            caseStats.addRequest();
        }
        defaultStats.addExecutionTime(tss.exTime);
        if (caseStats != null) {
            caseStats.addExecutionTime(tss.exTime);
        }
        if (tss.errorInstance != null) {
            defaultStats.notifyError(tss.errorInstance);
            if (caseStats != null) {
                caseStats.notifyError();
            }
        }
        if (tss.servletException) {
            defaultStats.notifyServletException((Throwable)new ServletException());
            if (caseStats != null) {
                caseStats.notifyServletException((Throwable)new ServletException());
            }
        }
        if (tss.runtimeException) {
            defaultStats.notifyRuntimeException((Throwable)new RuntimeException());
            if (caseStats != null) {
                caseStats.notifyRuntimeException((Throwable)new RuntimeException());
            }
        }
        if (tss.ioException) {
            defaultStats.notifyIOException((Throwable)new IOException());
            if (caseStats != null) {
                caseStats.notifyIOException((Throwable)new IOException());
            }
        }
        if (tss.finished) {
            defaultStats.notifyRequestFinished();
            if (caseStats != null) {
                caseStats.notifyRequestFinished();
            }
        }
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        OnDemandStatsProducer<FilterStats> onDemandProducer = this.getProducer();
        if (onDemandProducer == null) {
            this.log.error("Access to filter before it's inited!");
            chain.doFilter(req, res);
            return;
        }
        TemporaryStatsStorage tss = new TemporaryStatsStorage();
        try {
            long startTime = System.nanoTime();
            chain.doFilter(req, res);
            tss.exTime = System.nanoTime() - startTime;
        }
        catch (ServletException e) {
            tss.servletException = true;
            tss.errorInstance = e;
            throw e;
        }
        catch (IOException e) {
            tss.ioException = true;
            tss.errorInstance = e;
            throw e;
        }
        catch (RuntimeException e) {
            tss.errorInstance = e;
            tss.runtimeException = true;
            throw e;
        }
        catch (Error e) {
            tss.errorInstance = e;
            throw e;
        }
        finally {
            tss.finished = true;
            tss.ip = req.getRemoteAddr();
            try {
                this.asyncProcessor.addToQueueDontWait((Object)tss);
            }
            catch (UnrecoverableQueueOverflowException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected String extractCaseName(ServletRequest req, ServletResponse res) {
        throw new AssertionError((Object)"Shouldn't be ever called!");
    }

    private static class QueueWorker
    implements IQueueWorker<TemporaryStatsStorage> {
        private AsyncSourceTldFilter parent;

        QueueWorker(AsyncSourceTldFilter parent) {
            this.parent = parent;
        }

        public void doWork(TemporaryStatsStorage workingElement) throws Exception {
            String ip = workingElement.ip;
            String hostName = InetAddress.getByName(ip).getHostName();
            int indexOfTld = hostName.lastIndexOf(46);
            if (indexOfTld != -1) {
                hostName = hostName.substring(indexOfTld + 1);
            }
            if (hostName.length() > 20) {
                hostName = hostName.substring(0, 20);
            }
            if (Character.isDigit(hostName.charAt(hostName.length() - 1))) {
                hostName = "-unresolved-";
            }
            this.parent.writeStatsToProducer(hostName, workingElement);
        }
    }

    private static class TemporaryStatsStorage {
        private String ip;
        private long exTime;
        private boolean finished;
        private boolean servletException;
        private boolean ioException;
        private boolean runtimeException;
        private Throwable errorInstance;

        private TemporaryStatsStorage() {
        }
    }
}

