/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.web.filters;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import net.anotheria.moskito.core.config.MoskitoConfiguration;
import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.dynamic.EntryCountLimitedOnDemandStatsProducer;
import net.anotheria.moskito.core.dynamic.IOnDemandStatsFactory;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducer;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducerException;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.predefined.FilterStats;
import net.anotheria.moskito.core.predefined.FilterStatsFactory;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.web.filters.caseextractor.FilterCaseExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericMonitoringFilter
implements Filter {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String INIT_PARAM_LIMIT = "limit";
    public static final String OTHER = "-other-";
    private Map<FilterCaseExtractor, OnDemandStatsProducer<FilterStats>> extractorMap = new HashMap<FilterCaseExtractor, OnDemandStatsProducer<FilterStats>>();

    private void beforeExecution(HttpServletRequest req) {
        for (Map.Entry<FilterCaseExtractor, OnDemandStatsProducer<FilterStats>> extractorEntry : this.extractorMap.entrySet()) {
            OnDemandStatsProducer<FilterStats> producer = extractorEntry.getValue();
            FilterStats defaultStats = (FilterStats)producer.getDefaultStats();
            String caseName = extractorEntry.getKey().extractCaseName(req);
            FilterStats caseStats = this.getCaseStats(caseName, producer);
            defaultStats.addRequest();
            if (caseStats == null) continue;
            caseStats.addRequest();
        }
    }

    private FilterStats getCaseStats(String caseName, OnDemandStatsProducer<FilterStats> producer) {
        if (caseName == null) {
            return null;
        }
        try {
            return (FilterStats)producer.getStats(caseName);
        }
        catch (OnDemandStatsProducerException e) {
            this.log.debug("Couldn't get stats for case : " + caseName + ", probably limit reached");
            try {
                return (FilterStats)producer.getStats(OTHER);
            }
            catch (OnDemandStatsProducerException e1) {
                this.log.error("This can't happen, 'OtherStats' aka -other- doesn't exists in producer for case " + caseName);
                return null;
            }
        }
    }

    private void afterExecution(HttpServletRequest req, long executionTime, Throwable t) {
        for (Map.Entry<FilterCaseExtractor, OnDemandStatsProducer<FilterStats>> extractorEntry : this.extractorMap.entrySet()) {
            OnDemandStatsProducer<FilterStats> producer = extractorEntry.getValue();
            FilterStats defaultStats = (FilterStats)producer.getDefaultStats();
            String caseName = extractorEntry.getKey().extractCaseName(req);
            FilterStats caseStats = this.getCaseStats(caseName, producer);
            defaultStats.addExecutionTime(executionTime);
            defaultStats.notifyRequestFinished();
            if (caseStats != null) {
                caseStats.addExecutionTime(executionTime);
                caseStats.notifyRequestFinished();
            }
            if (t == null) continue;
            if (t instanceof ServletException) {
                defaultStats.notifyServletException(t);
                if (caseStats == null) continue;
                caseStats.notifyServletException(t);
                continue;
            }
            if (t instanceof IOException) {
                defaultStats.notifyIOException(t);
                if (caseStats == null) continue;
                caseStats.notifyIOException(t);
                continue;
            }
            if (t instanceof RuntimeException) {
                defaultStats.notifyRuntimeException(t);
                if (caseStats == null) continue;
                caseStats.notifyRuntimeException(t);
                continue;
            }
            defaultStats.notifyError(t);
            if (caseStats == null) continue;
            caseStats.notifyError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (!(req instanceof HttpServletRequest)) {
            chain.doFilter(req, res);
            return;
        }
        this.beforeExecution((HttpServletRequest)req);
        long startTime = System.nanoTime();
        Throwable t = null;
        try {
            chain.doFilter(req, res);
        }
        catch (ServletException e) {
            t = e;
        }
        catch (IOException e) {
            t = e;
        }
        catch (RuntimeException e) {
            t = e;
        }
        catch (Error e) {
            t = e;
        }
        finally {
            long exTime = System.nanoTime() - startTime;
            this.afterExecution((HttpServletRequest)req, exTime, t);
        }
    }

    public void init(FilterConfig config) throws ServletException {
        int limit = -1;
        String pLimit = config.getInitParameter(INIT_PARAM_LIMIT);
        if (pLimit != null) {
            try {
                limit = Integer.parseInt(pLimit);
            }
            catch (NumberFormatException ignored) {
                this.log.warn("couldn't parse limit \"" + pLimit + "\", assume -1 aka no limit.");
            }
        }
        MoskitoConfiguration configuration = MoskitoConfigurationHolder.getConfiguration();
        net.anotheria.moskito.core.config.filter.FilterConfig filterConfig = configuration.getFilterConfig();
        Object[] extractorNames = filterConfig.getCaseExtractors();
        System.out.println("ConfiguredExtractors: " + Arrays.toString(extractorNames));
        if (extractorNames != null && extractorNames.length > 0) {
            for (Object extractorName : extractorNames) {
                try {
                    FilterCaseExtractor extractor = (FilterCaseExtractor)Class.forName((String)extractorName).newInstance();
                    OnDemandStatsProducer onDemandProducer = limit == -1 ? new OnDemandStatsProducer(extractor.getProducerId(), extractor.getCategory(), extractor.getSubsystem(), (IOnDemandStatsFactory)new FilterStatsFactory(this.getMonitoringIntervals())) : new EntryCountLimitedOnDemandStatsProducer(extractor.getProducerId(), extractor.getCategory(), extractor.getSubsystem(), (IOnDemandStatsFactory)new FilterStatsFactory(this.getMonitoringIntervals()), limit);
                    ProducerRegistryFactory.getProducerRegistryInstance().registerProducer((IStatsProducer)onDemandProducer);
                    this.extractorMap.put(extractor, (OnDemandStatsProducer<FilterStats>)onDemandProducer);
                    try {
                        if (limit == -1) continue;
                        onDemandProducer.getStats(OTHER);
                    }
                    catch (OnDemandStatsProducerException e) {
                        this.log.error("Can't create 'other' stats for limit excess", (Throwable)e);
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    this.log.error("Can't load filter case extractor " + (String)extractorName, (Throwable)e);
                }
            }
        }
    }

    public void destroy() {
    }

    protected Interval[] getMonitoringIntervals() {
        return Constants.getDefaultIntervals();
    }
}

