/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.web.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.anotheria.moskito.core.calltrace.CurrentlyTracedCall;
import net.anotheria.moskito.core.calltrace.NoTracedCall;
import net.anotheria.moskito.core.calltrace.RunningTraceContainer;
import net.anotheria.moskito.core.calltrace.TracedCall;
import net.anotheria.moskito.core.context.MoSKitoContext;
import net.anotheria.moskito.core.journey.Journey;
import net.anotheria.moskito.core.journey.JourneyManager;
import net.anotheria.moskito.core.journey.JourneyManagerFactory;
import net.anotheria.moskito.core.journey.NoSuchJourneyException;
import net.anotheria.moskito.web.filters.JourneyRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JourneyFilter
implements Filter {
    static final String SA_JOURNEY_RECORD = "mskJourneyRecord";
    private static final String PARAM_JOURNEY_RECORDING = "mskJourney";
    private static final String PARAM_VALUE_START = "start";
    private static final String PARAM_VALUE_STOP = "stop";
    public static final String PARAM_JOURNEY_NAME = "mskJourneyName";
    private static Logger log = LoggerFactory.getLogger(JourneyFilter.class);
    private JourneyManager journeyManager;

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest sreq, ServletResponse sres, FilterChain chain) throws IOException, ServletException {
        if (!(sreq instanceof HttpServletRequest)) {
            chain.doFilter(sreq, sres);
            return;
        }
        HttpServletRequest req = (HttpServletRequest)sreq;
        this.processParameters(req);
        HttpSession session = req.getSession(false);
        JourneyRecord record = null;
        Journey journey = null;
        if (session != null && (record = (JourneyRecord)session.getAttribute(SA_JOURNEY_RECORD)) != null) {
            try {
                journey = this.journeyManager.getJourney(record.getName());
            }
            catch (NoSuchJourneyException e) {
                journey = this.journeyManager.createJourney(record.getName());
            }
        }
        String url = "none";
        if (record != null) {
            url = req.getServletPath();
            if (req.getPathInfo() != null) {
                url = url + req.getPathInfo();
            }
            if (req.getQueryString() != null) {
                url = url + '?' + req.getQueryString();
            }
            RunningTraceContainer.startTracedCall((String)(record.getUseCaseName() + '-' + url));
        }
        try {
            chain.doFilter(sreq, sres);
        }
        finally {
            if (record != null) {
                TracedCall last = RunningTraceContainer.endTrace();
                if (last instanceof NoTracedCall) {
                    log.warn("Unexpectedly last is a NoTracedCall instead of CurrentlyTracedCall for " + url);
                } else {
                    journey.addUseCase((CurrentlyTracedCall)last);
                }
                RunningTraceContainer.cleanup();
            }
            MoSKitoContext.cleanup();
        }
    }

    private void processParameters(HttpServletRequest req) {
        HttpSession session;
        String command = req.getParameter(PARAM_JOURNEY_RECORDING);
        String name = req.getParameter(PARAM_JOURNEY_NAME);
        if (command == null) {
            return;
        }
        if (command.equals(PARAM_VALUE_STOP)) {
            session = req.getSession(false);
            if (session != null) {
                session.removeAttribute(SA_JOURNEY_RECORD);
            }
            try {
                this.journeyManager.getJourney(name).setActive(false);
            }
            catch (NoSuchJourneyException noSuchJourneyException) {
                // empty catch block
            }
        }
        if (command.equals(PARAM_VALUE_START)) {
            session = req.getSession();
            if (name == null || name.length() == 0) {
                name = "unnamed" + System.currentTimeMillis();
            }
            session.setAttribute(SA_JOURNEY_RECORD, (Object)new JourneyRecord(name));
            this.journeyManager.createJourney(name);
        }
    }

    public void init(FilterConfig chain) throws ServletException {
        this.journeyManager = JourneyManagerFactory.getJourneyManager();
    }
}

