/**
 ********************************************************************************
 *** CommentsPersistenceServiceImpl.java                                      ***
 *** The implementation of the ICommentsPersistenceService.                   ***
 *** generated by AnoSiteGenerator (ASG), Version: 1.3.3                      ***
 *** Copyright (C) 2005 - 2010 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.moskitodemo.sqltrace.persistence;

import net.anotheria.db.dao.DAOException;
import net.anotheria.db.service.BasePersistenceServiceJDBCImpl;
import net.anotheria.moskitodemo.sqltrace.persistence.data.Comment;
import net.anotheria.util.slicer.Segment;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public class CommentsPersistenceServiceImpl extends BasePersistenceServiceJDBCImpl implements ICommentsPersistenceService {

	// Generated by: class net.anotheria.asg.generator.model.db.JDBCPersistenceServiceGenerator.generateImplementation


	private static CommentsPersistenceServiceImpl instance;

    	// DAO Objects for data access.
	private CommentDAO commentDAO;

	// DAO Objects for data access.

	private CommentsPersistenceServiceImpl(){
	}

	static final CommentsPersistenceServiceImpl getInstance(){
		if (instance==null){
			instance = new CommentsPersistenceServiceImpl();
		}
		return instance;
	}

	public void init(){
		super.init();
		commentDAO = new CommentDAO();
		String currentDAO = null;
		try {
			Connection c = getConnection();
			log.info("Initializing DAO for Comment" );
			currentDAO = "Comment";
			commentDAO.init(c);
		}catch(DAOException e){
			log.fatal("init failed (dao:"+currentDAO+") ",e );
		}catch(SQLException e){
			log.fatal("init failed (sql) ",e );
		}catch(Exception e){
			System.out.println(e.getMessage()+" "+e.getClass());
			log.fatal("init failed (e) ",e );
		}
	}

	/**
	 * Returns all Comments objects stored.
	 */
	public List<Comment> getComments() throws CommentsPersistenceServiceException {
		log.debug("Call getComments() ");
		Connection c = null;
		try {
			c = getConnection();
			return commentDAO.getComments(c);
		}catch(SQLException e){
			log.error("getComments() ",e);
			throw new CommentsPersistenceServiceException(e);
		}catch(DAOException e){
			throw new CommentsPersistenceServiceException(e);
		}finally{
			release(c);
		}
	}

	/**
	 * Deletes a Comment object by id.
	 */
	public void deleteComment(String id) throws CommentsPersistenceServiceException {
		log.debug("Call deleteComment("+id+") ");
		Connection c = null;
		try {
			c = getConnection();
			commentDAO.deleteComment(c, id);
		}catch(SQLException e){
			log.error("deleteComment("+id+") ",e);
			throw new CommentsPersistenceServiceException(e);
		}catch(DAOException e){
			throw new CommentsPersistenceServiceException(e);
		}finally{
			release(c);
		}
	}

	/**
	 * Deletes multiple  Comment objects.
	 */
	public void deleteComments(List<Comment> list) throws CommentsPersistenceServiceException {
		log.debug("Call deleteComments("+list+") ");
		Connection c = null;
		try {
			c = getConnection();
			commentDAO.deleteComments(c, list);
			return;
		}catch(SQLException e){
			log.error("deleteComments("+list+") ",e);
			throw new CommentsPersistenceServiceException(e);
		}catch(DAOException e){
			throw new CommentsPersistenceServiceException(e);
		}finally{
			release(c);
		}
	}

	/**
	 * Returns the Comment object with the specified id.
	 */
	public Comment getComment(String id) throws CommentsPersistenceServiceException {
		log.debug("Call getComment("+id+") ");
		Connection c = null;
		try {
			c = getConnection();
			return commentDAO.getComment(c, id);
		}catch(CommentDAONoItemForIdFoundException e){
			throw new CommentNotFoundInCommentsPersistenceServiceException(id);
		}catch(SQLException e){
			log.error("getComment("+id+") ",e);
			throw new CommentsPersistenceServiceException(e);
		}catch(DAOException e){
			throw new CommentsPersistenceServiceException(e);
		}finally{
			release(c);
		}
	}

	/**
	 * Imports a new Comment object.
	 * Returns the imported version.
	 */
	public Comment importComment(Comment comment) throws CommentsPersistenceServiceException {
		log.debug("Call importComment("+comment+") ");
		Connection c = null;
		try {
			c = getConnection();
			return commentDAO.importComment(c, comment);
		}catch(SQLException e){
			log.error("importComment("+comment+") ",e);
			throw new CommentsPersistenceServiceException(e);
		}catch(DAOException e){
			throw new CommentsPersistenceServiceException(e);
		}finally{
			release(c);
		}
	}

	/**
	 * Imports multiple new Comment objects.
	 * Returns the imported versions.
	 */
	public List<Comment> importComments(List<Comment> list) throws CommentsPersistenceServiceException {
		log.debug("Call importComments("+list+") ");
		Connection c = null;
		try {
			c = getConnection();
			return commentDAO.importComments(c, list);
		}catch(SQLException e){
			log.error("importComments("+list+") ",e);
			throw new CommentsPersistenceServiceException(e);
		}catch(DAOException e){
			throw new CommentsPersistenceServiceException(e);
		}finally{
			release(c);
		}
	}

	/**
	 * Creates a new Comment object.
	 * Returns the created version.
	 */
	public Comment createComment(Comment comment) throws CommentsPersistenceServiceException {
		log.debug("Call createComment("+comment+") ");
		Connection c = null;
		try {
			c = getConnection();
			return commentDAO.createComment(c, comment);
		}catch(SQLException e){
			log.error("createComment("+comment+") ",e);
			throw new CommentsPersistenceServiceException(e);
		}catch(DAOException e){
			throw new CommentsPersistenceServiceException(e);
		}finally{
			release(c);
		}
	}

	/**
	 * Creates multiple new Comment objects.
	 * Returns the created versions.
	 */
	public List<Comment> createComments(List<Comment> list) throws CommentsPersistenceServiceException {
		log.debug("Call createComments("+list+") ");
		Connection c = null;
		try {
			c = getConnection();
			return commentDAO.createComments(c, list);
		}catch(SQLException e){
			log.error("createComments("+list+") ",e);
			throw new CommentsPersistenceServiceException(e);
		}catch(DAOException e){
			throw new CommentsPersistenceServiceException(e);
		}finally{
			release(c);
		}
	}

	/**
	 * Updates a Comment object.
	 * Returns the updated version.
	 */
	public Comment updateComment(Comment comment) throws CommentsPersistenceServiceException {
		log.debug("Call updateComment("+comment+") ");
		Connection c = null;
		try {
			c = getConnection();
			return commentDAO.updateComment(c, comment);
		}catch(SQLException e){
			log.error("updateComment("+comment+") ",e);
			throw new CommentsPersistenceServiceException(e);
		}catch(DAOException e){
			throw new CommentsPersistenceServiceException(e);
		}finally{
			release(c);
		}
	}

	/**
	 * Updates multiple  Comment objects.
	 * Returns the updated versions.
	 */
	public List<Comment> updateComments(List<Comment> list) throws CommentsPersistenceServiceException {
		log.debug("Call updateComments("+list+") ");
		Connection c = null;
		try {
			c = getConnection();
			return commentDAO.updateComments(c, list);
		}catch(SQLException e){
			log.error("updateComments("+list+") ",e);
			throw new CommentsPersistenceServiceException(e);
		}catch(DAOException e){
			throw new CommentsPersistenceServiceException(e);
		}finally{
			release(c);
		}
	}

	/**
	 * Returns all Comment objects which match the given property.
	 */
	public List<Comment> getCommentsByProperty(QueryProperty... properties) throws CommentsPersistenceServiceException {
		log.debug("Call getCommentsByProperty("+properties+") ");
		Connection c = null;
		try {
			c = getConnection();
			return commentDAO.getCommentsByProperty(c, Arrays.asList(properties));
		}catch(SQLException e){
			log.error("getCommentsByProperty("+properties+") ",e);
			throw new CommentsPersistenceServiceException(e);
		}catch(DAOException e){
			throw new CommentsPersistenceServiceException(e);
		}finally{
			release(c);
		}
	}

	/**
	 * Returns Comments objects count.
	 */
	public int getCommentsCount() throws CommentsPersistenceServiceException {
		log.debug("Call getCommentsCount() ");
		Connection c = null;
		try {
			c = getConnection();
			return commentDAO.getCommentsCount(c);
		}catch(SQLException e){
			log.error("getCommentsCount() ",e);
			throw new CommentsPersistenceServiceException(e);
		}catch(DAOException e){
			throw new CommentsPersistenceServiceException(e);
		}finally{
			release(c);
		}
	}

	/**
	 * Returns Comments objects segment.
	 */
	public List<Comment> getComments(Segment aSegment) throws CommentsPersistenceServiceException {
		log.debug("Call getComments(" + aSegment + ") ");
		Connection c = null;
		try {
			c = getConnection();
			return commentDAO.getComments(c, aSegment);
		}catch(SQLException e){
			log.error("getComments(" + aSegment + ") ",e);
			throw new CommentsPersistenceServiceException(e);
		}catch(DAOException e){
			throw new CommentsPersistenceServiceException(e);
		}finally{
			release(c);
		}
	}

	/**
	 * Returns Comment objects segment which match the given property.
	 */
	public List<Comment> getCommentsByProperty(Segment aSegment, QueryProperty... aProperties) throws CommentsPersistenceServiceException {
		log.debug("Call getCommentsByProperty(" + aSegment + "," + aProperties + ") ");
		Connection c = null;
		try {
			c = getConnection();
			return commentDAO.getCommentsByProperty(c, aSegment, Arrays.asList(aProperties));
		}catch(SQLException e){
			log.error("getCommentsByProperty(" + aSegment + "," + aProperties + ") ",e);
			throw new CommentsPersistenceServiceException(e);
		}catch(DAOException e){
			throw new CommentsPersistenceServiceException(e);
		}finally{
			release(c);
		}
	}

}
