/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskitodemo.accumulator;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import net.anotheria.moskito.core.predefined.ServiceStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;

public class RandomProducer
implements IStatsProducer {
    private int limitReq;
    private int limitTime;
    private static AtomicInteger instanceCounter = new AtomicInteger(0);
    private int instanceId = instanceCounter.incrementAndGet();
    private Random rnd;
    private ArrayList<IStats> stats;
    private ServiceStats serviceStats;
    private static final Timer timer = new Timer("RandomProducers", true);

    public RandomProducer(int aLimitReq, int aLimitTime) {
        this.limitReq = aLimitReq;
        this.limitTime = aLimitTime;
        this.rnd = new Random(System.nanoTime());
        this.serviceStats = new ServiceStats("cumulated");
        this.stats = new ArrayList();
        this.stats.add(this.serviceStats);
        ProducerRegistryFactory.getProducerRegistryInstance().registerProducer((IStatsProducer)this);
        timer.scheduleAtFixedRate((TimerTask)new /* Unavailable Anonymous Inner Class!! */, 0L, 60000L);
    }

    public void generateTraffic() {
        int numberOfReq = this.rnd.nextInt(this.limitReq);
        int i = 0;
        while (i < numberOfReq) {
            int duration = this.rnd.nextInt(this.limitTime);
            this.serviceStats.addExecutionTime(1000000L * (long)duration);
            this.serviceStats.addRequest();
            this.serviceStats.notifyRequestFinished();
            ++i;
        }
    }

    public List<IStats> getStats() {
        return this.stats;
    }

    public String getProducerId() {
        return "Random" + this.instanceId;
    }

    public String getCategory() {
        return "service";
    }

    public String getSubsystem() {
        return "accumulator-random";
    }
}

