/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskitodemo.guestbook.business;

import net.anotheria.moskitodemo.guestbook.business.AuthorizationServiceException;
import net.anotheria.moskitodemo.guestbook.business.BusinessConstants;
import net.anotheria.moskitodemo.guestbook.business.IAuthorizationService;
import net.anotheria.util.IOUtils;
import net.anotheria.util.StringUtils;
import org.apache.log4j.Logger;

public class AuthorizationServiceImpl
implements IAuthorizationService {
    private String storedKey = null;
    private static Logger log = Logger.getLogger(AuthorizationServiceImpl.class);

    AuthorizationServiceImpl() {
        this._load();
    }

    public boolean keyMatches(String key) throws AuthorizationServiceException {
        if (this.storedKey == null) {
            log.warn((Object)"No stored key, denying everything.");
            return false;
        }
        return this.storedKey.equals(key);
    }

    private void _load() {
        try {
            String stored = IOUtils.readFileAtOnceAsString((String)BusinessConstants.getKeyFilePath());
            this.storedKey = StringUtils.removeChars((String)stored, (char[])new char[]{'\n', '\r'});
            log.info((Object)("loaded key: " + this.storedKey));
        }
        catch (Exception e) {
            log.error((Object)"_load", (Throwable)e);
        }
    }
}

