/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskitodemo.guestbook.business;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.anotheria.moskito.core.util.storage.Storage;
import net.anotheria.moskitodemo.guestbook.business.BusinessCommentCounter;
import net.anotheria.moskitodemo.guestbook.business.BusinessConstants;
import net.anotheria.moskitodemo.guestbook.business.CommentServiceException;
import net.anotheria.moskitodemo.guestbook.business.ICommentService;
import net.anotheria.moskitodemo.guestbook.business.NoSuchCommentException;
import net.anotheria.moskitodemo.guestbook.business.data.Comment;
import net.anotheria.moskitodemo.guestbook.business.data.CommentSortType;
import net.anotheria.util.sorter.QuickSorter;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.sorter.Sorter;
import org.apache.log4j.Logger;

public class CommentServiceImpl
implements ICommentService {
    private AtomicInteger nextId;
    private Storage<Integer, Comment> comments;
    private Sorter<Comment> sorter;
    private BusinessCommentCounter counter = new BusinessCommentCounter();
    private static Logger log = Logger.getLogger(CommentServiceImpl.class);

    CommentServiceImpl() {
        this.nextId = new AtomicInteger(1);
        this.comments = Storage.createConcurrentHashMapStorage();
        this.sorter = new QuickSorter();
        this._load();
    }

    public Comment createComment() throws CommentServiceException {
        Comment c = new Comment(this.nextId.getAndIncrement());
        this.comments.put((Object)c.getId(), (Object)c);
        this.counter.created();
        this._save();
        return c;
    }

    public void deleteComment(int id) throws CommentServiceException {
        Comment old = (Comment)this.comments.remove((Object)id);
        if (old != null) {
            this.counter.deleted();
            this._save();
        }
    }

    public void deleteComments(List<Integer> ids) throws CommentServiceException {
        for (Integer id : ids) {
            this.comments.remove((Object)id);
            this.counter.deleted();
        }
        this._save();
    }

    public Comment getComment(int id) throws CommentServiceException {
        Comment c = (Comment)this.comments.get((Object)id);
        if (c == null) {
            throw new NoSuchCommentException(id);
        }
        return c;
    }

    public List<Comment> getComments() throws CommentServiceException {
        return this.getCommentsSorted(new CommentSortType());
    }

    public List<Comment> getCommentsSorted(CommentSortType sortType) throws CommentServiceException {
        return this.sorter.sort(this.createListFromMap(), (SortType)sortType);
    }

    private List<Comment> createListFromMap() {
        return new ArrayList<Comment>(this.comments.values());
    }

    public void updateComment(Comment c) throws CommentServiceException {
        this.getComment(c.getId());
        this.comments.put((Object)c.getId(), (Object)c);
        this._save();
    }

    private synchronized void _save() {
        block15: {
            ObjectOutputStream oOut = null;
            try {
                try {
                    File f = new File(BusinessConstants.getDataDir());
                    if (!f.exists()) {
                        f.mkdirs();
                    }
                    oOut = new ObjectOutputStream(new FileOutputStream(BusinessConstants.getCommentFilePath()));
                    oOut.writeObject(this.nextId);
                    oOut.writeObject(this.comments.fillMap(new HashMap(this.comments.size())));
                }
                catch (Exception e) {
                    log.error((Object)"_save", (Throwable)e);
                    if (oOut != null) {
                        try {
                            oOut.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (oOut != null) {
                    try {
                        oOut.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (oOut != null) {
                try {
                    oOut.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private synchronized void _load() {
        block14: {
            ObjectInputStream oIn = null;
            try {
                try {
                    FileInputStream fIn = new FileInputStream(BusinessConstants.getCommentFilePath());
                    oIn = new ObjectInputStream(fIn);
                    this.nextId = (AtomicInteger)oIn.readObject();
                    Map commentsMap = (Map)oIn.readObject();
                    this.comments.putAll(commentsMap);
                }
                catch (Exception e) {
                    log.error((Object)"_load", (Throwable)e);
                    if (oIn != null) {
                        try {
                            oIn.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (oIn != null) {
                    try {
                        oIn.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (oIn != null) {
                try {
                    oIn.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

