/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskitodemo.guestbook.business.data;

import java.io.Serializable;
import net.anotheria.util.BasicComparable;
import net.anotheria.util.NumberUtils;
import net.anotheria.util.sorter.IComparable;

public class Comment
implements Serializable,
IComparable {
    private static final long serialVersionUID = -2709559716434110636L;
    private int id;
    private String firstName;
    private String lastName;
    private String email;
    private String text;
    private long timestamp;
    private boolean wishesUpdates;

    public Comment(int anId) {
        this.id = anId;
        this.firstName = "";
        this.lastName = "";
        this.email = "";
        this.text = "";
        this.timestamp = System.currentTimeMillis();
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String toString() {
        return String.valueOf(this.id) + " " + NumberUtils.makeISO8601TimestampString((long)this.timestamp) + " " + this.firstName + " " + this.lastName + " (" + this.email + "):" + this.text;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        return o instanceof Comment ? ((Comment)o).id == this.id : false;
    }

    public int compareTo(IComparable anotherComparable, int method) {
        Comment anotherComment = (Comment)anotherComparable;
        switch (method) {
            case 3: {
                return BasicComparable.compareString((String)this.email, (String)anotherComment.email);
            }
            case 1: {
                return BasicComparable.compareString((String)this.firstName, (String)anotherComment.firstName);
            }
            case 2: {
                return BasicComparable.compareString((String)this.lastName, (String)anotherComment.lastName);
            }
            case 4: {
                return BasicComparable.compareInt((int)this.id, (int)anotherComment.id);
            }
            case 5: {
                return BasicComparable.compareLong((long)this.timestamp, (long)anotherComment.timestamp);
            }
            case 6: {
                return BasicComparable.compareString((String)this.text, (String)anotherComment.text);
            }
        }
        throw new RuntimeException("Unsupported sort method: " + method);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean wishesUpdates() {
        return this.wishesUpdates;
    }

    public void setWishesUpdates(boolean value) {
        this.wishesUpdates = value;
    }
}

