/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskitodemo.guestbook.presentation.bean;

import net.anotheria.maf.bean.FormBean;

public class CommentForm
implements FormBean {
    private String firstName;
    private String lastName;
    private String text;
    private String email;
    private boolean updateFlagChecked;
    public static final int MAX_TEXT_LENGTH = 1000;
    public static final int MAX_FIELD_LENGTH = 100;

    private String cutIfToLong(String s, int limit) {
        if (s == null || s.length() <= limit) {
            return s;
        }
        return String.valueOf(s.substring(0, limit - 3)) + "...";
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = this.cutIfToLong(email, 100);
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = this.cutIfToLong(firstName, 100);
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = this.cutIfToLong(lastName, 100);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = this.cutIfToLong(text, 1000);
    }

    public String toString() {
        return String.valueOf(this.firstName) + " " + this.lastName + " " + this.email + ", upd: " + this.updateFlagChecked + ", text: " + this.text;
    }

    public boolean isUpdateFlagChecked() {
        return this.updateFlagChecked;
    }

    public void setUpdateFlagChecked(boolean updateFlagChecked) {
        this.updateFlagChecked = updateFlagChecked;
    }
}

