/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskitodemo.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Random;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.moskito.core.predefined.ServletStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.web.MoskitoHttpServlet;

public class SimpleServlet
extends MoskitoHttpServlet {
    public static final int MODE_NORMAL_PROCESSING = 1;
    public static final int MODE_RANDOM = 2;
    public static final int MODE_ERROR = 3;
    private Random rnd;

    public void init() {
        this.rnd = new Random(System.currentTimeMillis());
    }

    protected void moskitoDoGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        int throwExceptionIf5;
        String showStatsParameterValue = req.getParameter("pShowInterval");
        if (showStatsParameterValue != null && showStatsParameterValue.length() > 0) {
            this.moskitoShowStats(req, res);
            return;
        }
        int mode = 1;
        try {
            mode = Integer.parseInt(req.getParameter("pMode"));
        }
        catch (Exception exception) {}
        int sleepTime = this.rnd.nextInt(1000);
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Thread interrupted: " + e.getMessage());
        }
        if (mode == 3) {
            throw new RuntimeException("Emulating exception in processing.");
        }
        if (mode == 2 && (throwExceptionIf5 = this.rnd.nextInt(10)) == 5) {
            throw new RuntimeException("Emulating exception in processing.");
        }
        this.writeResponse(res, sleepTime);
    }

    protected void moskitoShowStats(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String interval = req.getParameter("pShowInterval");
        if (interval == "default") {
            interval = null;
        }
        List stats = this.getStats();
        res.setContentType("text/html");
        PrintWriter writer = res.getWriter();
        writer.write("<html>\n");
        this.writeHtmlHead(writer, "SimpleServlet Stats for interval: " + interval);
        writer.write("<body>");
        writer.write("<H2>Stats for interval " + interval + " </H2>");
        writer.write("\n<br>\n");
        writer.write("<table border=\"1\" cellpadding=\"1\" cellspacing=\"1\">\n");
        writer.write("<tr>");
        writer.write("<th>method</th>");
        writer.write("<th>total request</th>");
        writer.write("<th>total time</th>");
        writer.write("<th>current requests</th>");
        writer.write("<th>max current requests</th>");
        writer.write("<th>errors</th>");
        writer.write("<th>io exc</th>");
        writer.write("<th>servlet exc</th>");
        writer.write("<th>runtime exc</th>");
        writer.write("<th>last time</th>");
        writer.write("<th>min time</th>");
        writer.write("<th>max time</th>");
        writer.write("<th>avg time</th>");
        writer.write("</tr>");
        for (IStats statObject : stats) {
            ServletStats stat = (ServletStats)statObject;
            writer.write("<tr>\n");
            writer.write("<td>" + stat.getMethodName() + "</td>");
            writer.write("<td>" + stat.getTotalRequests(interval) + "</td>");
            writer.write("<td>" + stat.getTotalTime(interval) + "</td>");
            writer.write("<td>" + stat.getCurrentRequests(interval) + "</td>");
            writer.write("<td>" + stat.getMaxCurrentRequests(interval) + "</td>");
            writer.write("<td>" + stat.getErrors(interval) + "</td>");
            writer.write("<td>" + stat.getIoExceptions(interval) + "</td>");
            writer.write("<td>" + stat.getServletExceptions(interval) + "</td>");
            writer.write("<td>" + stat.getRuntimeExceptions(interval) + "</td>");
            writer.write("<td>" + stat.getLastRequest(interval) + "</td>");
            writer.write("<td>" + stat.getMinTime(interval) + "</td>");
            writer.write("<td>" + stat.getMaxTime(interval) + "</td>");
            writer.write("<td>" + stat.getAverageRequestDuration(interval) + "</td>");
            writer.write("</tr>\n");
        }
        writer.write("</table>\n");
        writer.write("</body></html>");
        writer.close();
    }

    protected boolean useShortStatList() {
        return true;
    }

    private void writeResponse(HttpServletResponse res, int amountOfTimeSlept) throws IOException {
        res.setContentType("text/html");
        PrintWriter writer = res.getWriter();
        writer.write("<html>\n");
        this.writeHtmlHead(writer, "SimpleServlet Response");
        writer.write("<body><br>Servlet slept : " + amountOfTimeSlept + "</body></html>");
        writer.close();
    }

    private void writeHtmlHead(PrintWriter writer, String title) {
        writer.write("\n");
        writer.write("<head>\n");
        writer.write("<title>" + title + "</title>");
        writer.write("<META http-equiv=\"pragma\" content=\"no-cache\">\n");
        writer.write("<META http-equiv=\"Cache-Control\" content=\"no-cache, must-revalidate\">\n");
        writer.write("<META name=\"Expires\" content=\"0\">\n");
        writer.write("<META http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\n");
        writer.write("</head>\n");
    }
}

