/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskitodemo.simpleservice;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.anotheria.moskito.core.predefined.ServiceStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskitodemo.simpleservice.ISimpleService;

public class SimpleServiceImpl
implements ISimpleService,
IStatsProducer {
    private ServiceStats serviceStats = new ServiceStats("service");
    private ServiceStats randomWaitStats = new ServiceStats("randomWait");
    private ServiceStats waitForSoLongStats = new ServiceStats("waitForSoLong");
    private ServiceStats produceExceptionStats = new ServiceStats("produceException");
    private Random rnd = new Random(System.currentTimeMillis());

    SimpleServiceImpl() {
    }

    public List<IStats> getStats() {
        ArrayList<IStats> ret = new ArrayList<IStats>();
        ret.add((IStats)this.serviceStats);
        ret.add((IStats)this.randomWaitStats);
        ret.add((IStats)this.waitForSoLongStats);
        ret.add((IStats)this.produceExceptionStats);
        return ret;
    }

    public String getProducerId() {
        return "ISimpleService";
    }

    public void printStats() {
        this.printStats(null);
    }

    public void printStats(String interval) {
        System.out.println("=== STATS FOR " + (interval == null ? "DEFAULT" : interval) + " ====");
        List stats = this.getStats();
        for (IStats stat : stats) {
            System.out.println(stat.toStatsString(interval));
        }
        System.out.println("=== END OF STATS ===");
    }

    public void randomWait() throws Exception {
        this.serviceStats.addRequest();
        this.randomWaitStats.addRequest();
        try {
            try {
                long startTime = System.currentTimeMillis();
                Thread.sleep(this.rnd.nextInt(1000));
                long exTime = System.currentTimeMillis() - startTime;
                this.serviceStats.addExecutionTime(exTime);
                this.randomWaitStats.addExecutionTime(exTime);
            }
            catch (Exception unexpectedError) {
                this.serviceStats.notifyError();
                this.randomWaitStats.notifyError();
                throw unexpectedError;
            }
        }
        finally {
            this.serviceStats.notifyRequestFinished();
            this.randomWaitStats.notifyRequestFinished();
        }
    }

    public void waitForSoLongInMillis(long parameter) throws Exception {
        this.serviceStats.addRequest();
        this.waitForSoLongStats.addRequest();
        try {
            try {
                long startTime = System.currentTimeMillis();
                Thread.sleep(parameter);
                long exTime = System.currentTimeMillis() - startTime;
                this.serviceStats.addExecutionTime(exTime);
                this.waitForSoLongStats.addExecutionTime(exTime);
            }
            catch (Exception unexpectedError) {
                this.serviceStats.notifyError();
                this.waitForSoLongStats.notifyError();
                throw unexpectedError;
            }
        }
        finally {
            this.serviceStats.notifyRequestFinished();
            this.waitForSoLongStats.notifyRequestFinished();
        }
    }

    public void produceExceptionIfParameterIsEven(int parameter) throws Exception {
        this.serviceStats.addRequest();
        this.produceExceptionStats.addRequest();
        try {
            try {
                long startTime = System.currentTimeMillis();
                if (parameter / 2 * 2 == parameter) {
                    throw new RuntimeException("Parameter " + parameter + " is even");
                }
                long exTime = System.currentTimeMillis() - startTime;
                this.serviceStats.addExecutionTime(exTime);
                this.produceExceptionStats.addExecutionTime(exTime);
            }
            catch (Exception unexpectedError) {
                this.serviceStats.notifyError();
                this.produceExceptionStats.notifyError();
                throw unexpectedError;
            }
        }
        finally {
            this.serviceStats.notifyRequestFinished();
            this.produceExceptionStats.notifyRequestFinished();
        }
    }

    public String getCategory() {
        return "service";
    }

    public String getSubsystem() {
        return "default";
    }
}

