/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskitodemo.sqltrace.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import net.anotheria.db.config.JDBCConfig;
import net.anotheria.db.config.JDBCConfigFactory;
import net.anotheria.db.dao.DAO;
import net.anotheria.db.dao.DAOException;
import net.anotheria.db.dao.DAOSQLException;
import net.anotheria.db.dao.RowMapper;
import net.anotheria.db.util.JDBCUtil;
import net.anotheria.moskito.sql.callingAspect.ConnectionCallAspect;
import net.anotheria.moskitodemo.sqltrace.persistence.CommentDAO;
import net.anotheria.moskitodemo.sqltrace.persistence.CommentDAO$AjcClosure11;
import net.anotheria.moskitodemo.sqltrace.persistence.CommentDAO$AjcClosure17;
import net.anotheria.moskitodemo.sqltrace.persistence.CommentDAO$AjcClosure25;
import net.anotheria.moskitodemo.sqltrace.persistence.CommentDAO$AjcClosure29;
import net.anotheria.moskitodemo.sqltrace.persistence.CommentDAO$AjcClosure7;
import net.anotheria.moskitodemo.sqltrace.persistence.CommentDAONoItemForIdFoundException;
import net.anotheria.moskitodemo.sqltrace.persistence.CommentRowMapper;
import net.anotheria.moskitodemo.sqltrace.persistence.QueryProperty;
import net.anotheria.moskitodemo.sqltrace.persistence.data.Comment;
import net.anotheria.moskitodemo.sqltrace.persistence.data.CommentVO;
import net.anotheria.util.slicer.Segment;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CommentDAO
implements DAO {
    private static Logger log;
    public static final String TABNAME = "comment";
    public static final String ATT_NAME_ID = "id";
    public static final String ATT_NAME_FIRSTNAME = "firstname";
    public static final String ATT_NAME_LASTNAME = "lastname";
    public static final String ATT_NAME_EMAIL = "email";
    public static final String ATT_NAME_TEXT = "text";
    public static final String ATT_NAME_TIMESTAMP = "timestamp";
    public static final String ATT_NAME_WISHESUPDATES = "wishesupdates";
    public static final String SQL_CREATE_1 = "INSERT INTO ";
    public static final String SQL_CREATE_2 = " (id, firstname, lastname, email, text, timestamp, wishesupdates, dao_created) VALUES (?,?,?,?,?,?,?,?)";
    public static final String SQL_UPDATE_1 = "UPDATE ";
    public static final String SQL_UPDATE_2 = " SET firstname = ?, lastname = ?, email = ?, text = ?, timestamp = ?, wishesupdates = ?, dao_updated = ? WHERE id = ?";
    public static final String SQL_DELETE_1 = "DELETE FROM ";
    public static final String SQL_DELETE_2 = " WHERE comment.id = ?";
    public static final String SQL_READ_ONE_1 = "SELECT id, firstname, lastname, email, text, timestamp, wishesupdates, dao_created, dao_updated FROM ";
    public static final String SQL_READ_ONE_2 = " WHERE comment.id = ?";
    public static final String SQL_READ_ALL_1 = "SELECT id, firstname, lastname, email, text, timestamp, wishesupdates, dao_created, dao_updated FROM ";
    public static final String SQL_READ_ALL_2 = " ORDER BY id";
    public static final String SQL_READ_ALL_BY_PROPERTY_1 = "SELECT id, firstname, lastname, email, text, timestamp, wishesupdates, dao_created, dao_updated FROM ";
    public static final String SQL_READ_ALL_BY_PROPERTY_2 = " WHERE ";
    public static final String SQL_COUNT_1 = "SELECT COUNT(id) FROM ";
    public static final String SQL_LIMIT_1 = " LIMIT ?";
    public static final String SQL_OFFSET_1 = " OFFSET ?";
    private RowMapper<Comment> rowMapper = new CommentRowMapper();
    private AtomicLong lastId = new AtomicLong();
    private JDBCConfig dbConfig = JDBCConfigFactory.getJDBCConfig();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;

    static {
        CommentDAO.ajc$preClinit();
        log = Logger.getLogger(CommentDAO.class);
    }

    private AtomicLong getLastId(Connection con) throws DAOException {
        return this.lastId;
    }

    private void adjustLastId(Connection con, long lastIdValue) throws DAOException {
        if (this.lastId.get() < lastIdValue) {
            this.lastId.set(lastIdValue);
        }
    }

    private String createSQL(String sql1, String sql2) {
        StringBuilder sql = new StringBuilder();
        sql.append(sql1).append("comment").append(sql2);
        return sql.toString();
    }

    public List<Comment> getComments(Connection con) throws DAOException {
        ArrayList<Comment> arrayList;
        PreparedStatement ps = null;
        ResultSet result = null;
        try {
            PreparedStatement preparedStatement;
            con.setAutoCommit(true);
            String string = this.createSQL("SELECT id, firstname, lastname, email, text, timestamp, wishesupdates, dao_created, dao_updated FROM ", " ORDER BY id");
            Connection connection = con;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)connection, (Object)string);
            try {
                Object[] objectArray = new Object[]{this, connection, string, joinPoint};
                preparedStatement = (PreparedStatement)ConnectionCallAspect.aspectOf().doBasicProfiling(new AjcClosure1(objectArray).linkClosureAndJoinPoint(4112), string);
            }
            catch (Throwable throwable) {
                ConnectionCallAspect.aspectOf().afterThrowingQueryCall(string);
                throw throwable;
            }
            ps = preparedStatement;
            result = ps.executeQuery();
            ArrayList<Comment> ret = new ArrayList<Comment>();
            while (result.next()) {
                ret.add((Comment)this.rowMapper.map(result));
            }
            arrayList = ret;
        }
        catch (SQLException e) {
            try {
                log.error((Object)("getComments(" + con + ")"), (Throwable)e);
                throw new DAOSQLException(e);
            }
            catch (Throwable throwable) {
                JDBCUtil.release(result);
                JDBCUtil.release(ps);
                throw throwable;
            }
        }
        JDBCUtil.release((ResultSet)result);
        JDBCUtil.release((Statement)ps);
        return arrayList;
    }

    public void deleteComment(Connection con, String id) throws DAOException {
        PreparedStatement ps = null;
        try {
            try {
                PreparedStatement preparedStatement;
                con.setAutoCommit(true);
                String string = this.createSQL("DELETE FROM ", " WHERE comment.id = ?");
                Connection connection = con;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)connection, (Object)string);
                try {
                    Object[] objectArray = new Object[]{this, connection, string, joinPoint};
                    preparedStatement = (PreparedStatement)ConnectionCallAspect.aspectOf().doBasicProfiling(new AjcClosure3(objectArray).linkClosureAndJoinPoint(4112), string);
                }
                catch (Throwable throwable) {
                    ConnectionCallAspect.aspectOf().afterThrowingQueryCall(string);
                    throw throwable;
                }
                ps = preparedStatement;
                ps.setLong(1, Long.parseLong(id));
                int rows = ps.executeUpdate();
                if (rows != 1 && rows != 0) {
                    log.warn((Object)("Deleted more than one row of Comment: " + id));
                }
            }
            catch (SQLException e) {
                log.error((Object)("deleteComment(" + con + ", " + id + ")"), (Throwable)e);
                throw new DAOSQLException(e);
            }
        }
        catch (Throwable throwable) {
            JDBCUtil.release(ps);
            throw throwable;
        }
        JDBCUtil.release((Statement)ps);
    }

    public void deleteComments(Connection con, List<Comment> list) throws DAOException {
        PreparedStatement ps = null;
        try {
            try {
                PreparedStatement preparedStatement;
                con.setAutoCommit(false);
                String string = this.createSQL("DELETE FROM ", " WHERE comment.id = ?");
                Connection connection = con;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)connection, (Object)string);
                try {
                    Object[] objectArray = new Object[]{this, connection, string, joinPoint};
                    preparedStatement = (PreparedStatement)ConnectionCallAspect.aspectOf().doBasicProfiling(new AjcClosure5(objectArray).linkClosureAndJoinPoint(4112), string);
                }
                catch (Throwable throwable) {
                    ConnectionCallAspect.aspectOf().afterThrowingQueryCall(string);
                    throw throwable;
                }
                ps = preparedStatement;
                for (Comment comment : list) {
                    ps.setLong(1, Long.parseLong(comment.getId()));
                    int rows = ps.executeUpdate();
                    if (rows == 1 || rows == 0) continue;
                    log.warn((Object)("Deleted more than one row of Comment: " + comment.getId()));
                }
                con.commit();
            }
            catch (SQLException e) {
                log.error((Object)("deleteComments(" + con + ", " + list + ")"), (Throwable)e);
                throw new DAOSQLException(e);
            }
        }
        catch (Throwable throwable) {
            JDBCUtil.release(ps);
            throw throwable;
        }
        JDBCUtil.release((Statement)ps);
    }

    public Comment getComment(Connection con, String id) throws DAOException {
        Comment comment;
        if (con == null) {
            throw new IllegalArgumentException("Null arg: con");
        }
        if (id == null) {
            throw new IllegalArgumentException("Null arg: id");
        }
        PreparedStatement ps = null;
        ResultSet result = null;
        try {
            PreparedStatement preparedStatement;
            con.setAutoCommit(true);
            String string = this.createSQL("SELECT id, firstname, lastname, email, text, timestamp, wishesupdates, dao_created, dao_updated FROM ", " WHERE comment.id = ?");
            Connection connection = con;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)connection, (Object)string);
            try {
                Object[] objectArray = new Object[]{this, connection, string, joinPoint};
                preparedStatement = (PreparedStatement)ConnectionCallAspect.aspectOf().doBasicProfiling(new CommentDAO$AjcClosure7(objectArray).linkClosureAndJoinPoint(4112), string);
            }
            catch (Throwable throwable) {
                ConnectionCallAspect.aspectOf().afterThrowingQueryCall(string);
                throw throwable;
            }
            ps = preparedStatement;
            ps.setLong(1, Long.parseLong(id));
            result = ps.executeQuery();
            if (!result.next()) {
                throw new CommentDAONoItemForIdFoundException(id);
            }
            comment = (Comment)this.rowMapper.map(result);
        }
        catch (SQLException e) {
            try {
                log.error((Object)("getComment(" + con + ", " + id + ")"), (Throwable)e);
                throw new DAOSQLException(e);
            }
            catch (Throwable throwable) {
                JDBCUtil.release(result);
                JDBCUtil.release(ps);
                throw throwable;
            }
        }
        JDBCUtil.release((ResultSet)result);
        JDBCUtil.release((Statement)ps);
        return comment;
    }

    public Comment importComment(Connection con, Comment comment) throws DAOException {
        CommentVO commentVO;
        PreparedStatement ps = null;
        try {
            PreparedStatement preparedStatement;
            con.setAutoCommit(true);
            String string = this.createSQL("INSERT INTO ", " (id, firstname, lastname, email, text, timestamp, wishesupdates, dao_created) VALUES (?,?,?,?,?,?,?,?)");
            Connection connection = con;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)connection, (Object)string);
            try {
                Object[] objectArray = new Object[]{this, connection, string, joinPoint};
                preparedStatement = (PreparedStatement)ConnectionCallAspect.aspectOf().doBasicProfiling(new AjcClosure9(objectArray).linkClosureAndJoinPoint(4112), string);
            }
            catch (Throwable throwable) {
                ConnectionCallAspect.aspectOf().afterThrowingQueryCall(string);
                throw throwable;
            }
            ps = preparedStatement;
            ps.setLong(1, Long.parseLong(comment.getId()));
            ps.setString(2, comment.getFirstName());
            ps.setString(3, comment.getLastName());
            ps.setString(4, comment.getEmail());
            ps.setString(5, comment.getText());
            ps.setLong(6, comment.getTimestamp());
            ps.setBoolean(7, comment.getWishesUpdates());
            ps.setLong(8, System.currentTimeMillis());
            int rows = ps.executeUpdate();
            if (rows != 1) {
                throw new DAOException("Create failed, updated rows: " + rows);
            }
            CommentVO newComment = new CommentVO(comment.getId());
            newComment.copyAttributesFrom(comment);
            this.adjustLastId(con, Long.parseLong(comment.getId()));
            commentVO = newComment;
        }
        catch (SQLException e) {
            try {
                log.error((Object)("importComment(" + con + ", " + comment + ")"), (Throwable)e);
                throw new DAOSQLException(e);
            }
            catch (Throwable throwable) {
                JDBCUtil.release(ps);
                throw throwable;
            }
        }
        JDBCUtil.release((Statement)ps);
        return commentVO;
    }

    public List<Comment> importComments(Connection con, List<Comment> list) throws DAOException {
        ArrayList<Comment> arrayList;
        PreparedStatement ps = null;
        try {
            PreparedStatement preparedStatement;
            con.setAutoCommit(false);
            String string = this.createSQL("INSERT INTO ", " (id, firstname, lastname, email, text, timestamp, wishesupdates, dao_created) VALUES (?,?,?,?,?,?,?,?)");
            Connection connection = con;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)connection, (Object)string);
            try {
                Object[] objectArray = new Object[]{this, connection, string, joinPoint};
                preparedStatement = (PreparedStatement)ConnectionCallAspect.aspectOf().doBasicProfiling(new CommentDAO$AjcClosure11(objectArray).linkClosureAndJoinPoint(4112), string);
            }
            catch (Throwable throwable) {
                ConnectionCallAspect.aspectOf().afterThrowingQueryCall(string);
                throw throwable;
            }
            ps = preparedStatement;
            ArrayList<Comment> ret = new ArrayList<Comment>();
            for (Comment comment : list) {
                ps.setLong(1, Long.parseLong(comment.getId()));
                ps.setString(2, comment.getFirstName());
                ps.setString(3, comment.getLastName());
                ps.setString(4, comment.getEmail());
                ps.setString(5, comment.getText());
                ps.setLong(6, comment.getTimestamp());
                ps.setBoolean(7, comment.getWishesUpdates());
                ps.setLong(8, System.currentTimeMillis());
                int rows = ps.executeUpdate();
                if (rows != 1) {
                    throw new DAOException("Create failed, updated rows: " + rows);
                }
                CommentVO newComment = new CommentVO(comment.getId());
                newComment.copyAttributesFrom(comment);
                this.adjustLastId(con, Long.parseLong(comment.getId()));
                ret.add((Comment)newComment);
            }
            con.commit();
            arrayList = ret;
        }
        catch (SQLException e) {
            try {
                log.error((Object)("import Comments(" + con + ", " + list + ")"), (Throwable)e);
                throw new DAOSQLException(e);
            }
            catch (Throwable throwable) {
                JDBCUtil.release(ps);
                throw throwable;
            }
        }
        JDBCUtil.release((Statement)ps);
        return arrayList;
    }

    public Comment createComment(Connection con, Comment comment) throws DAOException {
        SQLException throwable = null;
        int recoveryAttempt = 1;
        while (recoveryAttempt <= this.dbConfig.getIdRecoveryAttempts()) {
            PreparedStatement ps = null;
            try {
                PreparedStatement preparedStatement;
                con.setAutoCommit(false);
                String string = this.createSQL("INSERT INTO ", " (id, firstname, lastname, email, text, timestamp, wishesupdates, dao_created) VALUES (?,?,?,?,?,?,?,?)");
                Connection connection = con;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)connection, (Object)string);
                try {
                    Object[] objectArray = new Object[]{this, connection, string, joinPoint};
                    preparedStatement = (PreparedStatement)ConnectionCallAspect.aspectOf().doBasicProfiling(new AjcClosure13(objectArray).linkClosureAndJoinPoint(4112), string);
                }
                catch (Throwable throwable2) {
                    ConnectionCallAspect.aspectOf().afterThrowingQueryCall(string);
                    throw throwable2;
                }
                ps = preparedStatement;
                long nextId = this.getLastId(con).incrementAndGet();
                ps.setLong(1, nextId);
                ps.setString(2, comment.getFirstName());
                ps.setString(3, comment.getLastName());
                ps.setString(4, comment.getEmail());
                ps.setString(5, comment.getText());
                ps.setLong(6, comment.getTimestamp());
                ps.setBoolean(7, comment.getWishesUpdates());
                ps.setLong(8, System.currentTimeMillis());
                int rows = ps.executeUpdate();
                if (rows != 1) {
                    throw new DAOException("Create failed, updated rows: " + rows);
                }
                CommentVO newComment = new CommentVO("" + nextId);
                newComment.copyAttributesFrom(comment);
                con.commit();
                CommentVO commentVO = newComment;
                JDBCUtil.release((Statement)ps);
                return commentVO;
            }
            catch (SQLException e) {
                this.getLastId(con).set(this.getMaxId(con, "comment"));
                log.warn((Object)("Failed attempt" + recoveryAttempt + " from " + this.dbConfig.getIdRecoveryAttempts() + " to create new entry in " + "comment" + " table"), (Throwable)e);
                throwable = e;
            }
            finally {
                JDBCUtil.release(ps);
            }
            ++recoveryAttempt;
        }
        log.error((Object)("All " + this.dbConfig.getIdRecoveryAttempts() + " attempt of id rereading - Failed. " + "createComment(" + con + ", " + comment + ")"), throwable);
        throw new DAOSQLException(throwable);
    }

    public List<Comment> createComments(Connection con, List<Comment> list) throws DAOException {
        SQLException throwable = null;
        int recoveryAttempt = 1;
        while (recoveryAttempt <= this.dbConfig.getIdRecoveryAttempts()) {
            PreparedStatement ps = null;
            try {
                PreparedStatement preparedStatement;
                con.setAutoCommit(false);
                String string = this.createSQL("INSERT INTO ", " (id, firstname, lastname, email, text, timestamp, wishesupdates, dao_created) VALUES (?,?,?,?,?,?,?,?)");
                Connection connection = con;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)connection, (Object)string);
                try {
                    Object[] objectArray = new Object[]{this, connection, string, joinPoint};
                    preparedStatement = (PreparedStatement)ConnectionCallAspect.aspectOf().doBasicProfiling(new AjcClosure15(objectArray).linkClosureAndJoinPoint(4112), string);
                }
                catch (Throwable throwable2) {
                    ConnectionCallAspect.aspectOf().afterThrowingQueryCall(string);
                    throw throwable2;
                }
                ps = preparedStatement;
                ArrayList<Comment> ret = new ArrayList<Comment>();
                for (Comment comment : list) {
                    long nextId = this.getLastId(con).incrementAndGet();
                    ps.setLong(1, nextId);
                    ps.setString(2, comment.getFirstName());
                    ps.setString(3, comment.getLastName());
                    ps.setString(4, comment.getEmail());
                    ps.setString(5, comment.getText());
                    ps.setLong(6, comment.getTimestamp());
                    ps.setBoolean(7, comment.getWishesUpdates());
                    ps.setLong(8, System.currentTimeMillis());
                    int rows = ps.executeUpdate();
                    if (rows != 1) {
                        throw new DAOException("Create failed, updated rows: " + rows);
                    }
                    CommentVO newComment = new CommentVO("" + nextId);
                    newComment.copyAttributesFrom(comment);
                    ret.add((Comment)newComment);
                }
                con.commit();
                ArrayList<Comment> arrayList = ret;
                JDBCUtil.release((Statement)ps);
                return arrayList;
            }
            catch (SQLException e) {
                this.getLastId(con).set(this.getMaxId(con, "comment"));
                log.warn((Object)("Failed attempt" + recoveryAttempt + " from " + this.dbConfig.getIdRecoveryAttempts() + " to create new entries (list) in " + "comment" + " table"), (Throwable)e);
                throwable = e;
            }
            finally {
                JDBCUtil.release(ps);
            }
            ++recoveryAttempt;
        }
        log.error((Object)("All " + this.dbConfig.getIdRecoveryAttempts() + " attempt of id rereading - Failed. " + "createComments(" + con + ", " + list + ")"), throwable);
        throw new DAOSQLException(throwable);
    }

    public Comment updateComment(Connection con, Comment comment) throws DAOException {
        Comment comment2;
        PreparedStatement ps = null;
        try {
            PreparedStatement preparedStatement;
            con.setAutoCommit(true);
            String string = this.createSQL("UPDATE ", " SET firstname = ?, lastname = ?, email = ?, text = ?, timestamp = ?, wishesupdates = ?, dao_updated = ? WHERE id = ?");
            Connection connection = con;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)connection, (Object)string);
            try {
                Object[] objectArray = new Object[]{this, connection, string, joinPoint};
                preparedStatement = (PreparedStatement)ConnectionCallAspect.aspectOf().doBasicProfiling(new CommentDAO$AjcClosure17(objectArray).linkClosureAndJoinPoint(4112), string);
            }
            catch (Throwable throwable) {
                ConnectionCallAspect.aspectOf().afterThrowingQueryCall(string);
                throw throwable;
            }
            ps = preparedStatement;
            ps.setString(1, comment.getFirstName());
            ps.setString(2, comment.getLastName());
            ps.setString(3, comment.getEmail());
            ps.setString(4, comment.getText());
            ps.setLong(5, comment.getTimestamp());
            ps.setBoolean(6, comment.getWishesUpdates());
            ps.setLong(7, System.currentTimeMillis());
            ps.setLong(8, Long.parseLong(comment.getId()));
            int rows = ps.executeUpdate();
            if (rows != 1) {
                throw new DAOException("Update failed, updated rows: " + rows);
            }
            comment2 = comment;
        }
        catch (SQLException e) {
            try {
                log.error((Object)("updateComment(" + con + ", " + comment + ")"), (Throwable)e);
                throw new DAOSQLException(e);
            }
            catch (Throwable throwable) {
                JDBCUtil.release(ps);
                throw throwable;
            }
        }
        JDBCUtil.release((Statement)ps);
        return comment2;
    }

    public List<Comment> updateComments(Connection con, List<Comment> list) throws DAOException {
        List<Comment> list2;
        PreparedStatement ps = null;
        try {
            PreparedStatement preparedStatement;
            con.setAutoCommit(false);
            String string = this.createSQL("UPDATE ", " SET firstname = ?, lastname = ?, email = ?, text = ?, timestamp = ?, wishesupdates = ?, dao_updated = ? WHERE id = ?");
            Connection connection = con;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)connection, (Object)string);
            try {
                Object[] objectArray = new Object[]{this, connection, string, joinPoint};
                preparedStatement = (PreparedStatement)ConnectionCallAspect.aspectOf().doBasicProfiling(new AjcClosure19(objectArray).linkClosureAndJoinPoint(4112), string);
            }
            catch (Throwable throwable) {
                ConnectionCallAspect.aspectOf().afterThrowingQueryCall(string);
                throw throwable;
            }
            ps = preparedStatement;
            new ArrayList();
            for (Comment comment : list) {
                ps.setString(1, comment.getFirstName());
                ps.setString(2, comment.getLastName());
                ps.setString(3, comment.getEmail());
                ps.setString(4, comment.getText());
                ps.setLong(5, comment.getTimestamp());
                ps.setBoolean(6, comment.getWishesUpdates());
                ps.setLong(7, System.currentTimeMillis());
                ps.setLong(8, Long.parseLong(comment.getId()));
                int rows = ps.executeUpdate();
                if (rows == 1) continue;
                throw new DAOException("Update failed, updated rows: " + rows);
            }
            con.commit();
            list2 = list;
        }
        catch (SQLException e) {
            try {
                log.error((Object)("updateComments(" + con + ", " + list + ")"), (Throwable)e);
                throw new DAOSQLException(e);
            }
            catch (Throwable throwable) {
                JDBCUtil.release(ps);
                throw throwable;
            }
        }
        JDBCUtil.release((Statement)ps);
        return list2;
    }

    public List<Comment> getCommentsByProperty(Connection con, List<QueryProperty> properties) throws DAOException {
        ArrayList<Comment> arrayList;
        PreparedStatement ps = null;
        ResultSet result = null;
        try {
            PreparedStatement preparedStatement;
            String SQL = this.createSQL("SELECT id, firstname, lastname, email, text, timestamp, wishesupdates, dao_created, dao_updated FROM ", " WHERE ");
            String whereClause = "";
            for (QueryProperty p : properties) {
                if (whereClause.length() > 0) {
                    whereClause = String.valueOf(whereClause) + " AND ";
                }
                String statement = p.unprepaireable() ? (String)p.getValue() : "?";
                whereClause = String.valueOf(whereClause) + p.getName().toLowerCase() + p.getComparator() + statement;
            }
            String string = SQL = String.valueOf(SQL) + whereClause;
            Connection connection = con;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)connection, (Object)string);
            try {
                Object[] objectArray = new Object[]{this, connection, string, joinPoint};
                preparedStatement = (PreparedStatement)ConnectionCallAspect.aspectOf().doBasicProfiling(new AjcClosure21(objectArray).linkClosureAndJoinPoint(4112), string);
            }
            catch (Throwable throwable) {
                ConnectionCallAspect.aspectOf().afterThrowingQueryCall(string);
                throw throwable;
            }
            ps = preparedStatement;
            int propertyPosition = 0;
            for (QueryProperty property : properties) {
                if (property.unprepaireable()) continue;
                this.setProperty(++propertyPosition, ps, property);
            }
            result = ps.executeQuery();
            ArrayList<Comment> ret = new ArrayList<Comment>();
            while (result.next()) {
                ret.add((Comment)this.rowMapper.map(result));
            }
            arrayList = ret;
        }
        catch (SQLException e) {
            try {
                log.error((Object)("getCommentsByProperty(" + con + "," + properties + ")"), (Throwable)e);
                throw new DAOSQLException(e);
            }
            catch (Throwable throwable) {
                JDBCUtil.release(result);
                JDBCUtil.release(ps);
                throw throwable;
            }
        }
        JDBCUtil.release((ResultSet)result);
        JDBCUtil.release((Statement)ps);
        return arrayList;
    }

    public int getCommentsCount(Connection con) throws DAOException {
        int n;
        PreparedStatement ps = null;
        ResultSet result = null;
        try {
            PreparedStatement preparedStatement;
            String string = "SELECT COUNT(id) FROM comment";
            Connection connection = con;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)connection, (Object)string);
            try {
                Object[] objectArray = new Object[]{this, connection, string, joinPoint};
                preparedStatement = (PreparedStatement)ConnectionCallAspect.aspectOf().doBasicProfiling(new AjcClosure23(objectArray).linkClosureAndJoinPoint(4112), string);
            }
            catch (Throwable throwable) {
                ConnectionCallAspect.aspectOf().afterThrowingQueryCall(string);
                throw throwable;
            }
            ps = preparedStatement;
            result = ps.executeQuery();
            int pCount = 0;
            if (result.next()) {
                pCount = result.getInt(1);
            }
            n = pCount;
        }
        catch (SQLException e) {
            try {
                log.error((Object)("getCommentsCount(" + con + ")"), (Throwable)e);
                throw new DAOSQLException(e);
            }
            catch (Throwable throwable) {
                JDBCUtil.release(result);
                JDBCUtil.release(ps);
                throw throwable;
            }
        }
        JDBCUtil.release((ResultSet)result);
        JDBCUtil.release((Statement)ps);
        return n;
    }

    public List<Comment> getComments(Connection con, Segment aSegment) throws DAOException {
        ArrayList<Comment> arrayList;
        PreparedStatement ps = null;
        ResultSet result = null;
        try {
            PreparedStatement preparedStatement;
            con.setAutoCommit(true);
            String string = String.valueOf(this.createSQL("SELECT id, firstname, lastname, email, text, timestamp, wishesupdates, dao_created, dao_updated FROM ", " ORDER BY id")) + " LIMIT ?" + " OFFSET ?";
            Connection connection = con;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)connection, (Object)string);
            try {
                Object[] objectArray = new Object[]{this, connection, string, joinPoint};
                preparedStatement = (PreparedStatement)ConnectionCallAspect.aspectOf().doBasicProfiling(new CommentDAO$AjcClosure25(objectArray).linkClosureAndJoinPoint(4112), string);
            }
            catch (Throwable throwable) {
                ConnectionCallAspect.aspectOf().afterThrowingQueryCall(string);
                throw throwable;
            }
            ps = preparedStatement;
            int pLimit = aSegment.getElementsPerSlice();
            int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
            ps.setInt(1, pLimit);
            ps.setInt(2, pOffset);
            result = ps.executeQuery();
            ArrayList<Comment> ret = new ArrayList<Comment>();
            while (result.next()) {
                ret.add((Comment)this.rowMapper.map(result));
            }
            arrayList = ret;
        }
        catch (SQLException e) {
            try {
                log.error((Object)("getComments(" + con + "," + aSegment + ")"), (Throwable)e);
                throw new DAOSQLException(e);
            }
            catch (Throwable throwable) {
                JDBCUtil.release(result);
                JDBCUtil.release(ps);
                throw throwable;
            }
        }
        JDBCUtil.release((ResultSet)result);
        JDBCUtil.release((Statement)ps);
        return arrayList;
    }

    public List<Comment> getCommentsByProperty(Connection con, Segment aSegment, List<QueryProperty> properties) throws DAOException {
        ArrayList<Comment> arrayList;
        PreparedStatement ps = null;
        ResultSet result = null;
        try {
            PreparedStatement preparedStatement;
            String SQL = this.createSQL("SELECT id, firstname, lastname, email, text, timestamp, wishesupdates, dao_created, dao_updated FROM ", " WHERE ");
            String whereClause = "";
            for (QueryProperty p : properties) {
                if (whereClause.length() > 0) {
                    whereClause = String.valueOf(whereClause) + " AND ";
                }
                String statement = p.unprepaireable() ? (String)p.getValue() : "?";
                whereClause = String.valueOf(whereClause) + p.getName() + p.getComparator() + (String)statement;
            }
            SQL = String.valueOf(SQL) + whereClause;
            String string = SQL = String.valueOf(SQL) + " ORDER BY id LIMIT ? OFFSET ?";
            Connection connection = con;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)connection, (Object)string);
            try {
                Object[] objectArray = new Object[]{this, connection, string, joinPoint};
                preparedStatement = (PreparedStatement)ConnectionCallAspect.aspectOf().doBasicProfiling(new AjcClosure27(objectArray).linkClosureAndJoinPoint(4112), string);
            }
            catch (Throwable throwable) {
                ConnectionCallAspect.aspectOf().afterThrowingQueryCall(string);
                throw throwable;
            }
            ps = preparedStatement;
            int propertyPosition = 0;
            for (QueryProperty property : properties) {
                if (property.unprepaireable()) continue;
                this.setProperty(++propertyPosition, ps, property);
            }
            int pLimit = aSegment.getElementsPerSlice();
            int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
            ps.setInt(++propertyPosition, pLimit);
            ps.setInt(++propertyPosition, pOffset);
            result = ps.executeQuery();
            ArrayList<Comment> ret = new ArrayList<Comment>();
            while (result.next()) {
                ret.add((Comment)this.rowMapper.map(result));
            }
            arrayList = ret;
        }
        catch (SQLException e) {
            try {
                log.error((Object)("getCommentsByProperty(" + con + "," + aSegment + "," + properties + ")"), (Throwable)e);
                throw new DAOSQLException(e);
            }
            catch (Throwable throwable) {
                JDBCUtil.release(result);
                JDBCUtil.release(ps);
                throw throwable;
            }
        }
        JDBCUtil.release((ResultSet)result);
        JDBCUtil.release((Statement)ps);
        return arrayList;
    }

    private void setProperty(int position, PreparedStatement ps, QueryProperty property) throws SQLException {
        if (property.unprepaireable()) {
            return;
        }
        if ("firstname".equals(property.getName().toLowerCase())) {
            ps.setString(position, (String)property.getValue());
            return;
        }
        if ("lastname".equals(property.getName().toLowerCase())) {
            ps.setString(position, (String)property.getValue());
            return;
        }
        if ("email".equals(property.getName().toLowerCase())) {
            ps.setString(position, (String)property.getValue());
            return;
        }
        if ("text".equals(property.getName().toLowerCase())) {
            ps.setString(position, (String)property.getValue());
            return;
        }
        if ("timestamp".equals(property.getName().toLowerCase())) {
            ps.setLong(position, (Long)property.getValue());
            return;
        }
        if ("wishesupdates".equals(property.getName().toLowerCase())) {
            ps.setBoolean(position, (Boolean)property.getValue());
            return;
        }
        if ("id".equals(property.getName())) {
            ps.setLong(position, (Long)property.getValue());
            return;
        }
        if ("dao_created".equals(property.getName())) {
            ps.setLong(position, (Long)property.getValue());
            return;
        }
        if ("dao_updated".equals(property.getName())) {
            ps.setLong(position, (Long)property.getValue());
            return;
        }
    }

    public void createStructure(Connection connection) throws DAOException {
    }

    public void deleteStructure(Connection connection) throws DAOException {
    }

    private long getMaxId(Connection con, String tableName) throws DAOException {
        long l;
        Statement st = null;
        ResultSet result = null;
        try {
            con.setAutoCommit(true);
            st = con.createStatement();
            String string = "SELECT MAX(id) FROM " + tableName;
            Statement statement = st;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)statement, (Object)string);
            try {
                Object[] objectArray = new Object[]{this, statement, string, joinPoint};
                Conversions.booleanValue((Object)ConnectionCallAspect.aspectOf().doBasicProfiling(new CommentDAO$AjcClosure29(objectArray).linkClosureAndJoinPoint(4112), string));
            }
            catch (Throwable throwable) {
                ConnectionCallAspect.aspectOf().afterThrowingQueryCall(string);
                throw throwable;
            }
            result = st.getResultSet();
            long maxId = 0L;
            if (result.next()) {
                maxId = result.getLong(1);
            }
            log.info((Object)("maxId in table " + tableName + " is " + maxId));
            l = maxId;
        }
        catch (SQLException e) {
            try {
                log.error((Object)("getMaxId(" + con + ", " + tableName + ")"), (Throwable)e);
                throw new DAOSQLException(e);
            }
            catch (Throwable throwable) {
                JDBCUtil.release(result);
                JDBCUtil.release((Statement)st);
                throw throwable;
            }
        }
        JDBCUtil.release((ResultSet)result);
        JDBCUtil.release((Statement)st);
        return l;
    }

    public void init(Connection con) throws DAOException {
        log.debug((Object)("Called: init(" + con + ")"));
        long maxId = this.getMaxId(con, "comment");
        maxId = maxId >= this.dbConfig.getStartId() ? maxId : this.dbConfig.getStartId();
        this.lastId = new AtomicLong(maxId);
    }

    static final /* synthetic */ PreparedStatement prepareStatement_aroundBody0(CommentDAO commentDAO, Connection connection, String string, JoinPoint joinPoint) {
        return connection.prepareStatement(string);
    }

    static final /* synthetic */ PreparedStatement prepareStatement_aroundBody2(CommentDAO commentDAO, Connection connection, String string, JoinPoint joinPoint) {
        return connection.prepareStatement(string);
    }

    static final /* synthetic */ PreparedStatement prepareStatement_aroundBody4(CommentDAO commentDAO, Connection connection, String string, JoinPoint joinPoint) {
        return connection.prepareStatement(string);
    }

    static final /* synthetic */ PreparedStatement prepareStatement_aroundBody6(CommentDAO commentDAO, Connection connection, String string, JoinPoint joinPoint) {
        return connection.prepareStatement(string);
    }

    static final /* synthetic */ PreparedStatement prepareStatement_aroundBody8(CommentDAO commentDAO, Connection connection, String string, JoinPoint joinPoint) {
        return connection.prepareStatement(string);
    }

    static final /* synthetic */ PreparedStatement prepareStatement_aroundBody10(CommentDAO commentDAO, Connection connection, String string, JoinPoint joinPoint) {
        return connection.prepareStatement(string);
    }

    static final /* synthetic */ PreparedStatement prepareStatement_aroundBody12(CommentDAO commentDAO, Connection connection, String string, JoinPoint joinPoint) {
        return connection.prepareStatement(string);
    }

    static final /* synthetic */ PreparedStatement prepareStatement_aroundBody14(CommentDAO commentDAO, Connection connection, String string, JoinPoint joinPoint) {
        return connection.prepareStatement(string);
    }

    static final /* synthetic */ PreparedStatement prepareStatement_aroundBody16(CommentDAO commentDAO, Connection connection, String string, JoinPoint joinPoint) {
        return connection.prepareStatement(string);
    }

    static final /* synthetic */ PreparedStatement prepareStatement_aroundBody18(CommentDAO commentDAO, Connection connection, String string, JoinPoint joinPoint) {
        return connection.prepareStatement(string);
    }

    static final /* synthetic */ PreparedStatement prepareStatement_aroundBody20(CommentDAO commentDAO, Connection connection, String string, JoinPoint joinPoint) {
        return connection.prepareStatement(string);
    }

    static final /* synthetic */ PreparedStatement prepareStatement_aroundBody22(CommentDAO commentDAO, Connection connection, String string, JoinPoint joinPoint) {
        return connection.prepareStatement(string);
    }

    static final /* synthetic */ PreparedStatement prepareStatement_aroundBody24(CommentDAO commentDAO, Connection connection, String string, JoinPoint joinPoint) {
        return connection.prepareStatement(string);
    }

    static final /* synthetic */ PreparedStatement prepareStatement_aroundBody26(CommentDAO commentDAO, Connection connection, String string, JoinPoint joinPoint) {
        return connection.prepareStatement(string);
    }

    static final /* synthetic */ boolean execute_aroundBody28(CommentDAO commentDAO, Statement statement, String string, JoinPoint joinPoint) {
        return statement.execute(string);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CommentDAO.java", CommentDAO.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "prepareStatement", "java.sql.Connection", "java.lang.String", "arg0", "java.sql.SQLException", "java.sql.PreparedStatement"), 94);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "prepareStatement", "java.sql.Connection", "java.lang.String", "arg0", "java.sql.SQLException", "java.sql.PreparedStatement"), 116);
        ajc$tjp_10 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "prepareStatement", "java.sql.Connection", "java.lang.String", "arg0", "java.sql.SQLException", "java.sql.PreparedStatement"), 421);
        ajc$tjp_11 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "prepareStatement", "java.sql.Connection", "java.lang.String", "arg0", "java.sql.SQLException", "java.sql.PreparedStatement"), 449);
        ajc$tjp_12 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "prepareStatement", "java.sql.Connection", "java.lang.String", "arg0", "java.sql.SQLException", "java.sql.PreparedStatement"), 472);
        ajc$tjp_13 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "prepareStatement", "java.sql.Connection", "java.lang.String", "arg0", "java.sql.SQLException", "java.sql.PreparedStatement"), 509);
        ajc$tjp_14 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "execute", "java.sql.Statement", "java.lang.String", "arg0", "java.sql.SQLException", "boolean"), 605);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "prepareStatement", "java.sql.Connection", "java.lang.String", "arg0", "java.sql.SQLException", "java.sql.PreparedStatement"), 137);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "prepareStatement", "java.sql.Connection", "java.lang.String", "arg0", "java.sql.SQLException", "java.sql.PreparedStatement"), 166);
        ajc$tjp_4 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "prepareStatement", "java.sql.Connection", "java.lang.String", "arg0", "java.sql.SQLException", "java.sql.PreparedStatement"), 189);
        ajc$tjp_5 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "prepareStatement", "java.sql.Connection", "java.lang.String", "arg0", "java.sql.SQLException", "java.sql.PreparedStatement"), 222);
        ajc$tjp_6 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "prepareStatement", "java.sql.Connection", "java.lang.String", "arg0", "java.sql.SQLException", "java.sql.PreparedStatement"), 262);
        ajc$tjp_7 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "prepareStatement", "java.sql.Connection", "java.lang.String", "arg0", "java.sql.SQLException", "java.sql.PreparedStatement"), 303);
        ajc$tjp_8 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "prepareStatement", "java.sql.Connection", "java.lang.String", "arg0", "java.sql.SQLException", "java.sql.PreparedStatement"), 346);
        ajc$tjp_9 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "prepareStatement", "java.sql.Connection", "java.lang.String", "arg0", "java.sql.SQLException", "java.sql.PreparedStatement"), 377);
    }
}

