/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskitodemo.sqltrace.persistence;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import net.anotheria.db.dao.DAOException;
import net.anotheria.db.service.BasePersistenceServiceJDBCImpl;
import net.anotheria.moskitodemo.sqltrace.persistence.CommentDAO;
import net.anotheria.moskitodemo.sqltrace.persistence.CommentDAONoItemForIdFoundException;
import net.anotheria.moskitodemo.sqltrace.persistence.CommentNotFoundInCommentsPersistenceServiceException;
import net.anotheria.moskitodemo.sqltrace.persistence.CommentsPersistenceServiceException;
import net.anotheria.moskitodemo.sqltrace.persistence.ICommentsPersistenceService;
import net.anotheria.moskitodemo.sqltrace.persistence.QueryProperty;
import net.anotheria.moskitodemo.sqltrace.persistence.data.Comment;
import net.anotheria.util.slicer.Segment;

public class CommentsPersistenceServiceImpl
extends BasePersistenceServiceJDBCImpl
implements ICommentsPersistenceService {
    private static CommentsPersistenceServiceImpl instance;
    private CommentDAO commentDAO;

    private CommentsPersistenceServiceImpl() {
    }

    static final CommentsPersistenceServiceImpl getInstance() {
        if (instance == null) {
            instance = new CommentsPersistenceServiceImpl();
        }
        return instance;
    }

    public void init() {
        super.init();
        this.commentDAO = new CommentDAO();
        String currentDAO = null;
        try {
            Connection c = this.getConnection();
            this.log.info((Object)"Initializing DAO for Comment");
            currentDAO = "Comment";
            this.commentDAO.init(c);
        }
        catch (DAOException e) {
            this.log.fatal((Object)("init failed (dao:" + currentDAO + ") "), (Throwable)e);
        }
        catch (SQLException e) {
            this.log.fatal((Object)"init failed (sql) ", (Throwable)e);
        }
        catch (Exception e) {
            System.out.println(String.valueOf(e.getMessage()) + " " + e.getClass());
            this.log.fatal((Object)"init failed (e) ", (Throwable)e);
        }
    }

    public List<Comment> getComments() throws CommentsPersistenceServiceException {
        this.log.debug((Object)"Call getComments() ");
        Connection c = null;
        try {
            c = this.getConnection();
            List list = this.commentDAO.getComments(c);
            return list;
        }
        catch (SQLException e) {
            this.log.error((Object)"getComments() ", (Throwable)e);
            throw new CommentsPersistenceServiceException(e);
        }
        catch (DAOException e) {
            throw new CommentsPersistenceServiceException(e);
        }
        finally {
            this.release(c);
        }
    }

    public void deleteComment(String id) throws CommentsPersistenceServiceException {
        this.log.debug((Object)("Call deleteComment(" + id + ") "));
        Connection c = null;
        try {
            try {
                c = this.getConnection();
                this.commentDAO.deleteComment(c, id);
            }
            catch (SQLException e) {
                this.log.error((Object)("deleteComment(" + id + ") "), (Throwable)e);
                throw new CommentsPersistenceServiceException(e);
            }
            catch (DAOException e) {
                throw new CommentsPersistenceServiceException(e);
            }
        }
        finally {
            this.release(c);
        }
    }

    public void deleteComments(List<Comment> list) throws CommentsPersistenceServiceException {
        this.log.debug((Object)("Call deleteComments(" + list + ") "));
        Connection c = null;
        try {
            c = this.getConnection();
            this.commentDAO.deleteComments(c, list);
            return;
        }
        catch (SQLException e) {
            this.log.error((Object)("deleteComments(" + list + ") "), (Throwable)e);
            throw new CommentsPersistenceServiceException(e);
        }
        catch (DAOException e) {
            throw new CommentsPersistenceServiceException(e);
        }
        finally {
            this.release(c);
        }
    }

    public Comment getComment(String id) throws CommentsPersistenceServiceException {
        this.log.debug((Object)("Call getComment(" + id + ") "));
        Connection c = null;
        try {
            c = this.getConnection();
            Comment comment = this.commentDAO.getComment(c, id);
            return comment;
        }
        catch (CommentDAONoItemForIdFoundException commentDAONoItemForIdFoundException) {
            throw new CommentNotFoundInCommentsPersistenceServiceException(id);
        }
        catch (SQLException e) {
            this.log.error((Object)("getComment(" + id + ") "), (Throwable)e);
            throw new CommentsPersistenceServiceException(e);
        }
        catch (DAOException e) {
            throw new CommentsPersistenceServiceException(e);
        }
        finally {
            this.release(c);
        }
    }

    public Comment importComment(Comment comment) throws CommentsPersistenceServiceException {
        this.log.debug((Object)("Call importComment(" + comment + ") "));
        Connection c = null;
        try {
            c = this.getConnection();
            Comment comment2 = this.commentDAO.importComment(c, comment);
            return comment2;
        }
        catch (SQLException e) {
            this.log.error((Object)("importComment(" + comment + ") "), (Throwable)e);
            throw new CommentsPersistenceServiceException(e);
        }
        catch (DAOException e) {
            throw new CommentsPersistenceServiceException(e);
        }
        finally {
            this.release(c);
        }
    }

    public List<Comment> importComments(List<Comment> list) throws CommentsPersistenceServiceException {
        this.log.debug((Object)("Call importComments(" + list + ") "));
        Connection c = null;
        try {
            c = this.getConnection();
            List list2 = this.commentDAO.importComments(c, list);
            return list2;
        }
        catch (SQLException e) {
            this.log.error((Object)("importComments(" + list + ") "), (Throwable)e);
            throw new CommentsPersistenceServiceException(e);
        }
        catch (DAOException e) {
            throw new CommentsPersistenceServiceException(e);
        }
        finally {
            this.release(c);
        }
    }

    public Comment createComment(Comment comment) throws CommentsPersistenceServiceException {
        this.log.debug((Object)("Call createComment(" + comment + ") "));
        Connection c = null;
        try {
            c = this.getConnection();
            Comment comment2 = this.commentDAO.createComment(c, comment);
            return comment2;
        }
        catch (SQLException e) {
            this.log.error((Object)("createComment(" + comment + ") "), (Throwable)e);
            throw new CommentsPersistenceServiceException(e);
        }
        catch (DAOException e) {
            throw new CommentsPersistenceServiceException(e);
        }
        finally {
            this.release(c);
        }
    }

    public List<Comment> createComments(List<Comment> list) throws CommentsPersistenceServiceException {
        this.log.debug((Object)("Call createComments(" + list + ") "));
        Connection c = null;
        try {
            c = this.getConnection();
            List list2 = this.commentDAO.createComments(c, list);
            return list2;
        }
        catch (SQLException e) {
            this.log.error((Object)("createComments(" + list + ") "), (Throwable)e);
            throw new CommentsPersistenceServiceException(e);
        }
        catch (DAOException e) {
            throw new CommentsPersistenceServiceException(e);
        }
        finally {
            this.release(c);
        }
    }

    public Comment updateComment(Comment comment) throws CommentsPersistenceServiceException {
        this.log.debug((Object)("Call updateComment(" + comment + ") "));
        Connection c = null;
        try {
            c = this.getConnection();
            Comment comment2 = this.commentDAO.updateComment(c, comment);
            return comment2;
        }
        catch (SQLException e) {
            this.log.error((Object)("updateComment(" + comment + ") "), (Throwable)e);
            throw new CommentsPersistenceServiceException(e);
        }
        catch (DAOException e) {
            throw new CommentsPersistenceServiceException(e);
        }
        finally {
            this.release(c);
        }
    }

    public List<Comment> updateComments(List<Comment> list) throws CommentsPersistenceServiceException {
        this.log.debug((Object)("Call updateComments(" + list + ") "));
        Connection c = null;
        try {
            c = this.getConnection();
            List list2 = this.commentDAO.updateComments(c, list);
            return list2;
        }
        catch (SQLException e) {
            this.log.error((Object)("updateComments(" + list + ") "), (Throwable)e);
            throw new CommentsPersistenceServiceException(e);
        }
        catch (DAOException e) {
            throw new CommentsPersistenceServiceException(e);
        }
        finally {
            this.release(c);
        }
    }

    public List<Comment> getCommentsByProperty(QueryProperty ... properties) throws CommentsPersistenceServiceException {
        this.log.debug((Object)("Call getCommentsByProperty(" + properties + ") "));
        Connection c = null;
        try {
            c = this.getConnection();
            List list = this.commentDAO.getCommentsByProperty(c, Arrays.asList(properties));
            return list;
        }
        catch (SQLException e) {
            this.log.error((Object)("getCommentsByProperty(" + properties + ") "), (Throwable)e);
            throw new CommentsPersistenceServiceException(e);
        }
        catch (DAOException e) {
            throw new CommentsPersistenceServiceException(e);
        }
        finally {
            this.release(c);
        }
    }

    public int getCommentsCount() throws CommentsPersistenceServiceException {
        this.log.debug((Object)"Call getCommentsCount() ");
        Connection c = null;
        try {
            c = this.getConnection();
            int n = this.commentDAO.getCommentsCount(c);
            return n;
        }
        catch (SQLException e) {
            this.log.error((Object)"getCommentsCount() ", (Throwable)e);
            throw new CommentsPersistenceServiceException(e);
        }
        catch (DAOException e) {
            throw new CommentsPersistenceServiceException(e);
        }
        finally {
            this.release(c);
        }
    }

    public List<Comment> getComments(Segment aSegment) throws CommentsPersistenceServiceException {
        this.log.debug((Object)("Call getComments(" + aSegment + ") "));
        Connection c = null;
        try {
            c = this.getConnection();
            List list = this.commentDAO.getComments(c, aSegment);
            return list;
        }
        catch (SQLException e) {
            this.log.error((Object)("getComments(" + aSegment + ") "), (Throwable)e);
            throw new CommentsPersistenceServiceException(e);
        }
        catch (DAOException e) {
            throw new CommentsPersistenceServiceException(e);
        }
        finally {
            this.release(c);
        }
    }

    public List<Comment> getCommentsByProperty(Segment aSegment, QueryProperty ... aProperties) throws CommentsPersistenceServiceException {
        this.log.debug((Object)("Call getCommentsByProperty(" + aSegment + "," + aProperties + ") "));
        Connection c = null;
        try {
            c = this.getConnection();
            List list = this.commentDAO.getCommentsByProperty(c, aSegment, Arrays.asList(aProperties));
            return list;
        }
        catch (SQLException e) {
            this.log.error((Object)("getCommentsByProperty(" + aSegment + "," + aProperties + ") "), (Throwable)e);
            throw new CommentsPersistenceServiceException(e);
        }
        catch (DAOException e) {
            throw new CommentsPersistenceServiceException(e);
        }
        finally {
            this.release(c);
        }
    }
}

