/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskitodemo.threshold.presentation.listener;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import net.anotheria.moskito.core.threshold.Threshold;
import net.anotheria.moskito.core.threshold.ThresholdConditionGuard;
import net.anotheria.moskito.core.threshold.ThresholdDefinition;
import net.anotheria.moskito.core.threshold.ThresholdRepository;
import net.anotheria.moskito.core.threshold.ThresholdStatus;
import net.anotheria.moskito.core.threshold.Thresholds;
import net.anotheria.moskito.core.threshold.guard.DoubleBarrierPassGuard;
import net.anotheria.moskito.core.threshold.guard.GuardedDirection;
import net.anotheria.moskito.core.threshold.guard.LongBarrierPassGuard;

public class SetupThresholds
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
        System.out.println("Configuring thresholds ... ");
        this.setupServiceTRThreshold();
        this.setupServiceAVGThreshold();
        this.setupRequestURIThreshold();
        this.setupMemory();
        System.out.println(" ... done.");
    }

    private void setupServiceTRThreshold() {
        ThresholdDefinition config = new ThresholdDefinition();
        config.setProducerName("GuardedService-1");
        config.setStatName("guardedMethod");
        config.setValueName("TR");
        config.setIntervalName("snapshot");
        config.setName("GuardedService TotalRequest");
        Threshold threshold = ThresholdRepository.getInstance().createThreshold(config);
        threshold.addGuard((ThresholdConditionGuard)new LongBarrierPassGuard(ThresholdStatus.GREEN, 1L, GuardedDirection.UP));
        threshold.addGuard((ThresholdConditionGuard)new LongBarrierPassGuard(ThresholdStatus.YELLOW, 100L, GuardedDirection.UP));
        threshold.addGuard((ThresholdConditionGuard)new LongBarrierPassGuard(ThresholdStatus.ORANGE, 200L, GuardedDirection.UP));
        threshold.addGuard((ThresholdConditionGuard)new LongBarrierPassGuard(ThresholdStatus.RED, 500L, GuardedDirection.UP));
        threshold.addGuard((ThresholdConditionGuard)new LongBarrierPassGuard(ThresholdStatus.PURPLE, 1000L, GuardedDirection.UP));
    }

    private void setupServiceAVGThreshold() {
        ThresholdDefinition config = new ThresholdDefinition();
        config.setProducerName("GuardedService-1");
        config.setStatName("guardedAverageMethod");
        config.setValueName("AVG");
        config.setIntervalName("snapshot");
        config.setName("GuardedService AVG");
        Threshold threshold = ThresholdRepository.getInstance().createThreshold(config);
        threshold.addGuard((ThresholdConditionGuard)new DoubleBarrierPassGuard(ThresholdStatus.GREEN, 1000.0, GuardedDirection.UP));
        threshold.addGuard((ThresholdConditionGuard)new DoubleBarrierPassGuard(ThresholdStatus.YELLOW, 2000.0, GuardedDirection.UP));
        threshold.addGuard((ThresholdConditionGuard)new DoubleBarrierPassGuard(ThresholdStatus.ORANGE, 3000.0, GuardedDirection.UP));
        threshold.addGuard((ThresholdConditionGuard)new DoubleBarrierPassGuard(ThresholdStatus.RED, 4000.0, GuardedDirection.UP));
        threshold.addGuard((ThresholdConditionGuard)new DoubleBarrierPassGuard(ThresholdStatus.PURPLE, 5000.0, GuardedDirection.UP));
    }

    private void setupRequestURIThreshold() {
        ThresholdDefinition config = new ThresholdDefinition();
        config.setProducerName("RequestURIFilter");
        config.setStatName("/moskitodemo/guestbook/gbookShowComments");
        config.setValueName("TR");
        config.setIntervalName("snapshot");
        config.setName("Guestbook");
        Threshold threshold = ThresholdRepository.getInstance().createThreshold(config);
        threshold.addGuard((ThresholdConditionGuard)new LongBarrierPassGuard(ThresholdStatus.GREEN, 1L, GuardedDirection.UP));
        threshold.addGuard((ThresholdConditionGuard)new LongBarrierPassGuard(ThresholdStatus.YELLOW, 10L, GuardedDirection.UP));
        threshold.addGuard((ThresholdConditionGuard)new LongBarrierPassGuard(ThresholdStatus.ORANGE, 20L, GuardedDirection.UP));
        threshold.addGuard((ThresholdConditionGuard)new LongBarrierPassGuard(ThresholdStatus.RED, 50L, GuardedDirection.UP));
        threshold.addGuard((ThresholdConditionGuard)new LongBarrierPassGuard(ThresholdStatus.PURPLE, 100L, GuardedDirection.UP));
    }

    private void setupMemory() {
        this.setupMemoryThreshold("PermGenFree", "MemoryPool-PS Perm Gen-NonHeap", "Free", new ThresholdConditionGuard[]{new LongBarrierPassGuard(ThresholdStatus.GREEN, 5000000L, GuardedDirection.UP), new LongBarrierPassGuard(ThresholdStatus.YELLOW, 5000000L, GuardedDirection.DOWN), new LongBarrierPassGuard(ThresholdStatus.ORANGE, 2000000L, GuardedDirection.DOWN), new LongBarrierPassGuard(ThresholdStatus.RED, 1000000L, GuardedDirection.DOWN), new LongBarrierPassGuard(ThresholdStatus.PURPLE, 1000L, GuardedDirection.DOWN)});
        this.setupMemoryThreshold("OldGenFree", "MemoryPool-PS Old Gen-Heap", "Free", new ThresholdConditionGuard[]{new LongBarrierPassGuard(ThresholdStatus.GREEN, 100000000L, GuardedDirection.UP), new LongBarrierPassGuard(ThresholdStatus.YELLOW, 50000000L, GuardedDirection.DOWN), new LongBarrierPassGuard(ThresholdStatus.ORANGE, 10000000L, GuardedDirection.DOWN), new LongBarrierPassGuard(ThresholdStatus.RED, 2000000L, GuardedDirection.DOWN), new LongBarrierPassGuard(ThresholdStatus.PURPLE, 1000000L, GuardedDirection.DOWN)});
    }

    private void setupMemoryThreshold(String name, String producerName, String valueName, ThresholdConditionGuard ... guards) {
        Thresholds.addMemoryThreshold((String)name, (String)producerName, (String)valueName, (ThresholdConditionGuard[])guards);
    }

    private void setupUrlAVG(String name, String url, ThresholdConditionGuard ... guards) {
        Thresholds.addUrlAVGThreshold((String)name, (String)url, (ThresholdConditionGuard[])guards);
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

