/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskitodemo.usecases.qe.business;

import net.anotheria.moskitodemo.usecases.qe.business.DoubleEquationResult;
import net.anotheria.moskitodemo.usecases.qe.business.IQECalculator;
import net.anotheria.moskitodemo.usecases.qe.business.NegativeDeterminantException;
import net.anotheria.moskitodemo.usecases.qe.business.QECalculatorException;

public class QECalculatorImpl
implements IQECalculator {
    public int calculateDeterminant(int a, int b, int c) throws QECalculatorException {
        int d = b * b - 4 * a * c;
        if (d < 0) {
            throw new NegativeDeterminantException(d);
        }
        return d;
    }

    public DoubleEquationResult solveForPositiveDeterminat(int a, int b, int c) throws QECalculatorException {
        int D = this.calculateDeterminant(a, b, c);
        if (D == 0) {
            throw new QECalculatorException("Determinant is zero");
        }
        double x1 = ((double)(-1 * b) + Math.sqrt(D)) / (double)(2 * a);
        double x2 = ((double)(-1 * b) - Math.sqrt(D)) / (double)(2 * a);
        return new DoubleEquationResult(x1, x2);
    }

    public int solveForZeroDeterminant(int a, int b, int c) throws QECalculatorException {
        int D = this.calculateDeterminant(a, b, c);
        if (D != 0) {
            throw new QECalculatorException("Determinant isn't zero.");
        }
        return -1 * b / (2 * a);
    }
}

