/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskitodemo.usecases.qe.business;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.moskito.core.dynamic.IOnDemandCallHandler;
import net.anotheria.moskito.core.dynamic.IOnDemandStatsFactory;
import net.anotheria.moskito.core.dynamic.MoskitoInvokationProxy;
import net.anotheria.moskito.core.predefined.ServiceStatsCallHandler;
import net.anotheria.moskito.core.predefined.ServiceStatsFactory;
import net.anotheria.moskitodemo.usecases.qe.business.DoubleEquationResult;
import net.anotheria.moskitodemo.usecases.qe.business.IQECalculator;
import net.anotheria.moskitodemo.usecases.qe.business.IQESolver;
import net.anotheria.moskitodemo.usecases.qe.business.QECalculatorException;
import net.anotheria.moskitodemo.usecases.qe.business.QECalculatorFactory;

public class QESolverImpl
implements IQESolver {
    private IQECalculator calc;

    public QESolverImpl() {
        IQECalculator _calc = QECalculatorFactory.createQECalculator();
        MoskitoInvokationProxy proxy = new MoskitoInvokationProxy((Object)_calc, (IOnDemandCallHandler)new ServiceStatsCallHandler(), (IOnDemandStatsFactory)new ServiceStatsFactory(), new Class[]{IQECalculator.class});
        this.calc = (IQECalculator)proxy.createProxy();
    }

    public List<Double> solveQuadrationEquation(int a, int b, int c) {
        ArrayList<Double> ret = new ArrayList<Double>();
        try {
            int d = this.calc.calculateDeterminant(a, b, c);
            if (d < 0) {
                return ret;
            }
            if (d == 0) {
                ret.add(Double.valueOf(this.calc.solveForZeroDeterminant(a, b, c)));
            }
            if (d > 0) {
                DoubleEquationResult res = this.calc.solveForPositiveDeterminat(a, b, c);
                ret.add(res.getX1());
                ret.add(res.getX2());
            }
        }
        catch (QECalculatorException qECalculatorException) {}
        return ret;
    }
}

