/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskitodemo.usecases.qe.presentation;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.AbstractAction;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.maf.bean.FormBean;
import net.anotheria.maf.bean.annotations.Form;
import net.anotheria.moskito.core.dynamic.IOnDemandCallHandler;
import net.anotheria.moskito.core.dynamic.IOnDemandStatsFactory;
import net.anotheria.moskito.core.dynamic.MoskitoInvokationProxy;
import net.anotheria.moskito.core.predefined.ServiceStatsCallHandler;
import net.anotheria.moskito.core.predefined.ServiceStatsFactory;
import net.anotheria.moskitodemo.usecases.qe.business.IQESolver;
import net.anotheria.moskitodemo.usecases.qe.business.QESolverImpl;
import net.anotheria.moskitodemo.usecases.qe.presentation.QEParameterForm;

public class SolveQEAction
extends AbstractAction {
    private IQESolver solver = (IQESolver)new MoskitoInvokationProxy((Object)new QESolverImpl(), (IOnDemandCallHandler)new ServiceStatsCallHandler(), (IOnDemandStatsFactory)new ServiceStatsFactory(), new Class[]{IQESolver.class}).createProxy();

    public ActionCommand execute(ActionMapping mapping, @Form(value=QEParameterForm.class) FormBean af, HttpServletRequest req, HttpServletResponse res) throws Exception {
        QEParameterForm form = (QEParameterForm)af;
        System.out.println("Called QESolver with form: " + form);
        if (form.isEmpty()) {
            System.out.println("Form is empty!");
            return mapping.success();
        }
        int a = 0;
        int b = 0;
        int c = 0;
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            a = Integer.parseInt(form.getA());
        }
        catch (NumberFormatException numberFormatException) {
            errorMessages.add("Parameter a is not a number: " + form.getA());
        }
        try {
            b = Integer.parseInt(form.getB());
        }
        catch (NumberFormatException numberFormatException) {
            errorMessages.add("Parameter b is not a number: " + form.getB());
        }
        try {
            c = Integer.parseInt(form.getC());
        }
        catch (NumberFormatException numberFormatException) {
            errorMessages.add("Parameter c is not a number: " + form.getC());
        }
        System.out.println("Errors: " + errorMessages);
        if (errorMessages.size() > 0) {
            req.setAttribute("errors", errorMessages);
            return mapping.success();
        }
        List solutions = this.solver.solveQuadrationEquation(a, b, c);
        if (solutions.size() == 0) {
            errorMessages.add("No solutions available");
            req.setAttribute("errors", errorMessages);
            return mapping.findForward("success");
        }
        System.out.println("Solver: " + solutions);
        req.setAttribute("solutions", (Object)solutions);
        return mapping.findForward("success");
    }
}

