/**
 ********************************************************************************
 *** BaseUserDataAction.java                                                  ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessapplicationdata.action;

import net.anotheria.anosite.gen.shared.action.BaseAnoAccessApplicationDataAction;
import javax.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.anoaccessapplicationdata.data.UserData;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseUserDataAction extends BaseAnoAccessApplicationDataAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "User Data";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "AnoAccessApplicationData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "UserData";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, UserData userdata) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("AnoAccessApplicationData.UserData").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("AnoAccessApplicationData.UserData", userdata, "userId");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.userId", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("AnoAccessApplicationData.UserData", userdata, "roles");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.roles", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockUserDatas(UserData userdata, HttpServletRequest req) throws Exception{
		if(userdata instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)userdata;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getAnoAccessApplicationDataService().updateUserData( userdata);
			logger.info("Lock-OPERATION, document with id : ["+userdata.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockUserDatas(UserData userdata, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(userdata instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)userdata;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getAnoAccessApplicationDataService().updateUserData( userdata);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+userdata.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+userdata.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkUserDatas(UserData userdata, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = userdata instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)userdata).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)userdata).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockUserDatas(userdata, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateUserDatas(UserData userdata, HttpServletRequest req) throws Exception{
		if(userdata instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)userdata, false, getUserId(req));
		}
		if (isTimeoutReached(userdata)) {
			checkUserDatas(userdata, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(userdata, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(UserData userdata){
		if (userdata instanceof LockableObject) {
			LockableObject lock = (LockableObject)userdata;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(UserData userdata, HttpServletRequest req){
		if (userdata instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)userdata;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
