/**
 ********************************************************************************
 *** MultiOpUserDatasRolesAction.java                                         ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessapplicationdata.action;

import java.util.List;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.anoaccessapplicationdata.data.UserDataFactory;
import net.anotheria.anosite.gen.anoaccessapplicationdata.data.UserData;
import net.anotheria.anosite.gen.anoaccessapplicationdata.bean.RolesElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.anoaccessapplicationdata.bean.RolesQuickAddFB;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.Role;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.RoleSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpUserDatasRolesAction extends BaseUserDataAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("anoaccessapplicationdataUserDataRolesShow"))
			return anoaccessapplicationdataUserDataRolesShow(mapping, req, res);
		if (path.equals("anoaccessapplicationdataUserDataRolesAdd"))
			return anoaccessapplicationdataUserDataRolesAdd(mapping, req, res);
		if (path.equals("anoaccessapplicationdataUserDataRolesDelete"))
			return anoaccessapplicationdataUserDataRolesDelete(mapping, req, res);
		if (path.equals("anoaccessapplicationdataUserDataRolesMove"))
			return anoaccessapplicationdataUserDataRolesMove(mapping, req, res);
		if (path.equals("anoaccessapplicationdataUserDataRolesQuickAdd"))
			return anoaccessapplicationdataUserDataRolesQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand anoaccessapplicationdataUserDataRolesShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		UserData userdata = getAnoAccessApplicationDataService().getUserData(id);
		addBeanToRequest(req, "ownerId", id);
		checkUserDatas(userdata, req);

		RolesElementFB form = new RolesElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(userdata.getId());
		addBeanToRequest(req, "anoaccessapplicationdataUserDataRolesElementForm", form);

		RolesQuickAddFB quickAddForm = new RolesQuickAddFB() ;
		quickAddForm.setOwnerId(userdata.getId());
		addBeanToRequest(req, "anoaccessapplicationdataUserDataRolesQuickAddForm", quickAddForm);


		//link role to AnoAccessConfiguration.Role
		List<Role> roles = getAnoAccessConfigurationService().getRoles(new RoleSortType(RoleSortType.SORT_BY_NAME));
		List<LabelValueBean> rolesValues = new ArrayList<LabelValueBean>(roles.size());
		for (int i=0; i<roles.size(); i++){
			net.anotheria.anosite.gen.anoaccessconfiguration.data.Role tmp_role = (net.anotheria.anosite.gen.anoaccessconfiguration.data.Role) roles.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_role.getId(), tmp_role.getName()+" ["+tmp_role.getId()+"]" );
			rolesValues.add(bean);
		}
		addBeanToRequest(req, "roleValuesCollection", rolesValues);
		// generate list ...
		int size = userdata.getRolesSize();
		List<RolesElementFB> beans = new ArrayList<RolesElementFB>(size);
		for (int i=0; i<size; i++){
			String value = userdata.getRolesElement(i);
			RolesElementFB bean = new RolesElementFB();
			bean.setOwnerId(userdata.getId());
			bean.setPosition(i);
			bean.setRole(value);
			try{
				Role tmp_role = getAnoAccessConfigurationService().getRole(value);
				bean.setDescription(tmp_role.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand anoaccessapplicationdataUserDataRolesDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		UserData userdataCurr = getAnoAccessApplicationDataService().getUserData(id);
		canUpdateUserDatas(userdataCurr, req);
		checkUserDatas(userdataCurr, req);
		int position = getIntParameter(req, "pPosition");
		UserData userdata = getAnoAccessApplicationDataService().getUserData(id);
		userdata.removeRolesElement(position);
		getAnoAccessApplicationDataService().updateUserData(userdata);
		return anoaccessapplicationdataUserDataRolesShow(mapping, req, res);
	}

	public ActionCommand anoaccessapplicationdataUserDataRolesMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		UserData userdata = getAnoAccessApplicationDataService().getUserData(id);
		canUpdateUserDatas(userdata, req);
		checkUserDatas(userdata, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(userdata, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(userdata, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(userdata, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(userdata, position);
		return anoaccessapplicationdataUserDataRolesShow(mapping, req, res);
	}

	private void moveUp(UserData userdata, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		userdata.swapRolesElement(position, position-1);
		getAnoAccessApplicationDataService().updateUserData(userdata);
	}

	private void moveTop(UserData userdata, int position) throws ASGRuntimeException {
		List<String> targetList = userdata.getRoles();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		userdata.setRoles(targetList);
		getAnoAccessApplicationDataService().updateUserData(userdata);
	}

	private void moveDown(UserData userdata, int position) throws ASGRuntimeException {
		if (position<userdata.getRolesSize()-1){
			userdata.swapRolesElement(position, position+1);
			getAnoAccessApplicationDataService().updateUserData(userdata);
		}
	}

	private void moveBottom(UserData userdata, int position) throws ASGRuntimeException {
		List<String> targetList = userdata.getRoles();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		userdata.setRoles(targetList);
		getAnoAccessApplicationDataService().updateUserData(userdata);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand anoaccessapplicationdataUserDataRolesAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		RolesElementFB form = new RolesElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		UserData userdata;
		userdata = getAnoAccessApplicationDataService().getUserData(id);
		canUpdateUserDatas(userdata, req);
		checkUserDatas(userdata, req);
		userdata.addRolesElement(form.getRole());
		getAnoAccessApplicationDataService().updateUserData(userdata);
		return anoaccessapplicationdataUserDataRolesShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand anoaccessapplicationdataUserDataRolesQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		RolesQuickAddFB form = new RolesQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		UserData userdata;
		userdata = getAnoAccessApplicationDataService().getUserData(id);
		canUpdateUserDatas(userdata, req);
		checkUserDatas(userdata, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				userdata.addRolesElement(""+i);
			}
		}
		getAnoAccessApplicationDataService().updateUserData(userdata);
		return anoaccessapplicationdataUserDataRolesShow(mapping, req, res);
	}

}
