/**
 ********************************************************************************
 *** BaseConstraintAction.java                                                ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessconfiguration.action;

import net.anotheria.anosite.gen.shared.action.BaseAnoAccessConfigurationAction;
import javax.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.Constraint;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseConstraintAction extends BaseAnoAccessConfigurationAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Constraints";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "AnoAccessConfiguration";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "Constraint";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, Constraint constraint) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("AnoAccessConfiguration.Constraint").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("AnoAccessConfiguration.Constraint", constraint, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("AnoAccessConfiguration.Constraint", constraint, "className");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.className", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("AnoAccessConfiguration.Constraint", constraint, "contextInitializers");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.contextInitializers", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("AnoAccessConfiguration.Constraint", constraint, "parameter1");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameter1", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("AnoAccessConfiguration.Constraint", constraint, "parameter2");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameter2", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("AnoAccessConfiguration.Constraint", constraint, "parameter3");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameter3", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("AnoAccessConfiguration.Constraint", constraint, "parameter4");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameter4", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("AnoAccessConfiguration.Constraint", constraint, "parameter5");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameter5", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("AnoAccessConfiguration.Constraint", constraint, "description");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.description", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockConstraints(Constraint constraint, HttpServletRequest req) throws Exception{
		if(constraint instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)constraint;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getAnoAccessConfigurationService().updateConstraint( constraint);
			logger.info("Lock-OPERATION, document with id : ["+constraint.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockConstraints(Constraint constraint, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(constraint instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)constraint;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getAnoAccessConfigurationService().updateConstraint( constraint);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+constraint.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+constraint.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkConstraints(Constraint constraint, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = constraint instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)constraint).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)constraint).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockConstraints(constraint, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateConstraints(Constraint constraint, HttpServletRequest req) throws Exception{
		if(constraint instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)constraint, false, getUserId(req));
		}
		if (isTimeoutReached(constraint)) {
			checkConstraints(constraint, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(constraint, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(Constraint constraint){
		if (constraint instanceof LockableObject) {
			LockableObject lock = (LockableObject)constraint;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(Constraint constraint, HttpServletRequest req){
		if (constraint instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)constraint;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
