/**
 ********************************************************************************
 *** MultiOpDialogAccessOperationsAction.java                                 ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessconfiguration.action;

import net.anotheria.util.NumberUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.AccessOperationFactory;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.AccessOperation;
import net.anotheria.anosite.gen.anoaccessconfiguration.bean.EditAccessOperationFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;

public class MultiOpDialogAccessOperationsAction extends BaseAccessOperationAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("anoaccessconfigurationAccessOperationDelete"))
			return anoaccessconfigurationAccessOperationDelete(mapping, req, res);
		if (path.equals("anoaccessconfigurationAccessOperationDuplicate"))
			return anoaccessconfigurationAccessOperationDuplicate(mapping, req, res);
		if (path.equals("anoaccessconfigurationAccessOperationUpdate"))
			return anoaccessconfigurationAccessOperationUpdate(mapping, req, res);
		if (path.equals("anoaccessconfigurationAccessOperationClose"))
			return anoaccessconfigurationAccessOperationClose(mapping, req, res);
		if (path.equals("anoaccessconfigurationAccessOperationLock"))
			return anoaccessconfigurationAccessOperationLock(mapping, req, res);
		if (path.equals("anoaccessconfigurationAccessOperationUnLock"))
			return anoaccessconfigurationAccessOperationUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand anoaccessconfigurationAccessOperationDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			AccessOperation accessoperationCurr = getAnoAccessConfigurationService().getAccessOperation(id);
			if (accessoperationCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)accessoperationCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getAnoAccessConfigurationService().deleteAccessOperation(id);
		}
		res.sendRedirect("anoaccessconfigurationAccessOperationShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand anoaccessconfigurationAccessOperationDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		AccessOperation accessoperationSrc = getAnoAccessConfigurationService().getAccessOperation(id);
		AccessOperation accessoperationDest = AccessOperationFactory.createAccessOperation(accessoperationSrc);


		AccessOperation accessoperationCreated = getAnoAccessConfigurationService().createAccessOperation(accessoperationDest);
		res.sendRedirect("anoaccessconfigurationAccessOperationEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+accessoperationCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand anoaccessconfigurationAccessOperationUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditAccessOperationFB form = new EditAccessOperationFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		AccessOperation accessoperation = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		accessoperation = (AccessOperation)getAnoAccessConfigurationService().getAccessOperation(form.getId()).clone();
	}else{
		accessoperation = AccessOperationFactory.createAccessOperation();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	accessoperation.setName(form.getName());
	accessoperation.setDescription(form.getDescription());

	AccessOperation updatedCopy = null;
	if (create){
		updatedCopy = getAnoAccessConfigurationService().createAccessOperation(accessoperation);
	}else{
		canUpdateAccessOperations(accessoperation, req);
		checkAccessOperations(accessoperation, req);
		updatedCopy = getAnoAccessConfigurationService().updateAccessOperation(accessoperation);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("anoaccessconfigurationAccessOperationEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(accessoperation, req);
		res.sendRedirect("anoaccessconfigurationAccessOperationShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(AccessOperation accessoperation, HttpServletRequest req) throws Exception{
	if(((LockableObject)accessoperation).isLocked())
		unLockAccessOperations(accessoperation, req, false);
}

public ActionCommand anoaccessconfigurationAccessOperationLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	AccessOperation accessoperationCurr = id != null && !id.equals("") ? getAnoAccessConfigurationService().getAccessOperation(id) : null;
	if(accessoperationCurr != null && accessoperationCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)accessoperationCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockAccessOperations(accessoperationCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, accessoperationCurr));
	return null;
}

public ActionCommand anoaccessconfigurationAccessOperationUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	AccessOperation accessoperationCurr = id != null && !id.equals("") ? getAnoAccessConfigurationService().getAccessOperation(id) : null;
	if(accessoperationCurr != null && accessoperationCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)accessoperationCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockAccessOperations(accessoperationCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, accessoperationCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, AccessOperation item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "anoaccessconfigurationAccessOperationShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "anoaccessconfigurationAccessOperationEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "anoaccessconfigurationAccessOperationShow?ts="+System.currentTimeMillis();
}

public ActionCommand anoaccessconfigurationAccessOperationClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	AccessOperation accessoperationCurr = id != null && !id.equals("") ? getAnoAccessConfigurationService().getAccessOperation(id) : null;
	if(accessoperationCurr != null && accessoperationCurr instanceof LockableObject && ((LockableObject)accessoperationCurr).isLocked()) 
		unLockAccessOperations(accessoperationCurr, req, false);
	res.sendRedirect("anoaccessconfigurationAccessOperationShow?ts="+System.currentTimeMillis());
	return null;
}

}
