/**
 ********************************************************************************
 *** MultiOpDialogBrandsAction.java                                           ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asbrand.action;

import net.anotheria.util.NumberUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.asbrand.data.BrandFactory;
import net.anotheria.anosite.gen.asbrand.data.Brand;
import net.anotheria.anosite.gen.asbrand.bean.EditBrandFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;

public class MultiOpDialogBrandsAction extends BaseBrandAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("asbrandBrandDelete"))
			return asbrandBrandDelete(mapping, req, res);
		if (path.equals("asbrandBrandDuplicate"))
			return asbrandBrandDuplicate(mapping, req, res);
		if (path.equals("asbrandBrandUpdate"))
			return asbrandBrandUpdate(mapping, req, res);
		if (path.equals("asbrandBrandClose"))
			return asbrandBrandClose(mapping, req, res);
		if (path.equals("asbrandBrandLock"))
			return asbrandBrandLock(mapping, req, res);
		if (path.equals("asbrandBrandUnLock"))
			return asbrandBrandUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand asbrandBrandDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			Brand brandCurr = getASBrandService().getBrand(id);
			if (brandCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)brandCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASBrandService().deleteBrand(id);
		}
		res.sendRedirect("asbrandBrandShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand asbrandBrandDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		Brand brandSrc = getASBrandService().getBrand(id);
		Brand brandDest = BrandFactory.createBrand(brandSrc);






		Brand brandCreated = getASBrandService().createBrand(brandDest);
		res.sendRedirect("asbrandBrandEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+brandCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand asbrandBrandUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditBrandFB form = new EditBrandFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		Brand brand = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		brand = (Brand)getASBrandService().getBrand(form.getId()).clone();
	}else{
		brand = BrandFactory.createBrand();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	brand.setName(form.getName());
	brand.setDefaultBrand(form.isDefaultBrand());
	// skipped container urlsToMap
	// skipped container localizations
	// skipped container mediaLinks
	// skipped container attributes

	Brand updatedCopy = null;
	if (create){
		updatedCopy = getASBrandService().createBrand(brand);
	}else{
		canUpdateBrands(brand, req);
		checkBrands(brand, req);
		updatedCopy = getASBrandService().updateBrand(brand);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("asbrandBrandEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(brand, req);
		res.sendRedirect("asbrandBrandShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(Brand brand, HttpServletRequest req) throws Exception{
	if(((LockableObject)brand).isLocked())
		unLockBrands(brand, req, false);
}

public ActionCommand asbrandBrandLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Brand brandCurr = id != null && !id.equals("") ? getASBrandService().getBrand(id) : null;
	if(brandCurr != null && brandCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)brandCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockBrands(brandCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, brandCurr));
	return null;
}

public ActionCommand asbrandBrandUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Brand brandCurr = id != null && !id.equals("") ? getASBrandService().getBrand(id) : null;
	if(brandCurr != null && brandCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)brandCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockBrands(brandCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, brandCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, Brand item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "asbrandBrandShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "asbrandBrandEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "asbrandBrandShow?ts="+System.currentTimeMillis();
}

public ActionCommand asbrandBrandClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Brand brandCurr = id != null && !id.equals("") ? getASBrandService().getBrand(id) : null;
	if(brandCurr != null && brandCurr instanceof LockableObject && ((LockableObject)brandCurr).isLocked()) 
		unLockBrands(brandCurr, req, false);
	res.sendRedirect("asbrandBrandShow?ts="+System.currentTimeMillis());
	return null;
}

}
