/**
 ********************************************************************************
 *** BrandRestResource.java                                                   ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asbrand.rest;

import java.util.List;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.POST;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.codehaus.jettison.json.JSONArray;
import net.anotheria.anosite.gen.shared.util.ParserUtilService;
import net.anotheria.anosite.gen.asbrand.data.Brand;
import net.anotheria.anosite.gen.asbrand.service.IASBrandService;
import net.anotheria.anosite.gen.asbrand.service.ASBrandServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path("/brand")
public class BrandRestResource{

	private static final Logger LOGGER = LoggerFactory.getLogger(BrandRestResource.class);
	private IASBrandService asbrandService;
	private Gson gson;
	private GsonBuilder builder;

	public BrandRestResource() {
		builder = new GsonBuilder();
		builder.setPrettyPrinting();
		gson = builder.create();

		try {
			asbrandService = MetaFactory.get(IASBrandService.class);
		}catch(MetaFactoryException e){
			LOGGER.error("Unable to create service: I ASBrandService", e);
			throw new RuntimeException("Unable to create service", e);
		}
	}

	@GET
	@Produces("application/json;charset=utf-8")
	public Response getObjects() {

		List<Brand> result = null;
		try {
			result = asbrandService.getBrands();
		}catch(ASBrandServiceException e){
			LOGGER.error("Unable to getBrands", e);
			return Response.status(500).build();
		}

		return Response.status(201).entity(gson.toJson(result)).build();
	}

	@GET
	@Path("/{id}")
	@Produces("application/json;charset=utf-8")
	public Response getObject(@PathParam("id") String id) {

		Brand result = null;
		try {
			result = asbrandService.getBrand(id);
		}catch(ASBrandServiceException e){
			LOGGER.error("Unable to getBrand by id", e);
			return Response.status(500).build();
		}

		return Response.status(201).entity(gson.toJson(result)).build();
	}

	@POST
	@Consumes("application/json;charset=utf-8")
	public Response createTransferredObject(String input) {

		try {
			JSONArray array = new JSONArray(input);
			ParserUtilService.getInstance().addToQueueParsingDocuments(array);
		}catch(Exception e){
			LOGGER.error("Unable to parsing transferred objects", e);
			return Response.status(500).build();
		}
		return Response.status(201).build();
	}
}
