/**
 ********************************************************************************
 *** IASBrandService.java                                                     ***
 *** Generator: net.anotheria.asg.generator.model.ServiceGenerator            ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asbrand.service;

import java.util.List;
import net.anotheria.util.sorter.SortType;
import net.anotheria.anosite.gen.asbrand.data.Brand;
import java.util.Set;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.slicer.Segment;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.asg.service.ASGService;

public interface IASBrandService extends ASGService{

// Generated by: class net.anotheria.asg.generator.model.ServiceGenerator.generateInterface

	/**
	 * Returns all Brands objects stored.
	 */
	List<Brand> getBrands() throws ASBrandServiceException;

	/**
	 * Returns all Brands objects sorted by given sortType.
	 */
	List<Brand> getBrands(SortType sortType) throws ASBrandServiceException;

	/**
	 * Deletes a Brand object by id.
	 */
	void deleteBrand(String id) throws ASBrandServiceException;

	/**
	 * Deletes a Brand object.
	 */
	void deleteBrand(Brand brand) throws ASBrandServiceException;

	/**
	 * Deletes multiple Brand object.
	 */
	void deleteBrands(List<Brand> list) throws ASBrandServiceException;

	/**
	 * Returns the Brand object with the specified id.
	 */
	Brand getBrand(String id) throws ASBrandServiceException;

	/**
	 * Imports a new Brand object.
	 * Returns the created version.
	 */
	Brand importBrand(Brand brand) throws ASBrandServiceException;

	/**
	 * Imports multiple new  Brand object.
	 * Returns the created versions.
	 */
	List<Brand> importBrands(List<Brand> list) throws ASBrandServiceException;

	/**
	 * Creates a new Brand object.
	 * Returns the created version.
	 */
	Brand createBrand(Brand brand) throws ASBrandServiceException;

	/**
	 * Creates multiple new Brand objects.
	 * Returns the created versions.
	 */
	List<Brand> createBrands(List<Brand> list) throws ASBrandServiceException;

	/**
	 * Updates a Brand object.
	 * Returns the updated version.
	 */
	Brand updateBrand(Brand brand) throws ASBrandServiceException;

	/**
	 * Updates multiple Brand objects.
	 * Returns the updated versions.
	 */
	List<Brand> updateBrands(List<Brand> list) throws ASBrandServiceException;

	/**
	 * Returns all Brand objects, where property with given name equals object.
	 */
	List<Brand> getBrandsByProperty(String propertyName, Object value) throws ASBrandServiceException;

	/**
	 * Returns all Brand objects, where property with given name equals object, sorted.
	 */
	List<Brand> getBrandsByProperty(String propertyName, Object value, SortType sortType) throws ASBrandServiceException;

	/**
	 * Executes a query.
	 */
	QueryResult executeQueryOnBrands(DocumentQuery query) throws ASBrandServiceException;

	/**
	 * Returns all Brand objects, where property matches.
	 */
	List<Brand> getBrandsByProperty(QueryProperty... property) throws ASBrandServiceException;

	/**
	 * Returns all Brand objects, where property matches, sorted.
	 */
	List<Brand> getBrandsByProperty(SortType sortType, QueryProperty... property) throws ASBrandServiceException;

	/**
	 * Returns all Brands count.
	 */
	int getBrandsCount() throws ASBrandServiceException;

	/**
	 * Returns Brands objects segment.
	 */
	List<Brand> getBrands(Segment aSegment) throws ASBrandServiceException;

	/**
	 * Returns Brand objects segment, where property matches.
	 */
	List<Brand> getBrandsByProperty(Segment aSegment, QueryProperty... aProperty) throws ASBrandServiceException;

	/**
	 * Returns Brand objects segment, where property matches, sorted.
	 */
	List<Brand> getBrandsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty) throws ASBrandServiceException;

	/**
	 * Creates an xml element with selected contained data.
	 */
	XMLNode exportBrandsToXML(List<Brand> listBrands)  throws ASBrandServiceException;

	/**
	 * Create json object list dependencies for this Brand document.
	 */
	void fetchBrand(String id, Set<String> addedDocuments, JSONArray data) throws ASBrandServiceException;

	/**
	 * Save transferred document by its own type.
	 */
	void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws ASBrandServiceException;
	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service.
	 */
	QueryResult executeQueryOnAllObjects(DocumentQuery query) throws ASBrandServiceException;
	/**
	 * creates an xml element with all contained data.
	 */
	XMLNode exportToXML() throws ASBrandServiceException;

}
