/**
 ********************************************************************************
 *** BaseCustomBoxTypeAction.java                                             ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.ascustomdata.action;

import net.anotheria.anosite.gen.shared.action.BaseDefinitionsAction;
import javax.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.ascustomdata.data.CustomBoxType;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseCustomBoxTypeAction extends BaseDefinitionsAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "CustomBoxType";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASCustomData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "CustomBoxType";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, CustomBoxType customboxtype) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASCustomData.CustomBoxType").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASCustomData.CustomBoxType", customboxtype, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASCustomData.CustomBoxType", customboxtype, "rendererpage");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.rendererpage", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockCustomBoxTypes(CustomBoxType customboxtype, HttpServletRequest req) throws Exception{
		if(customboxtype instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)customboxtype;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASCustomDataService().updateCustomBoxType( customboxtype);
			logger.info("Lock-OPERATION, document with id : ["+customboxtype.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockCustomBoxTypes(CustomBoxType customboxtype, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(customboxtype instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)customboxtype;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASCustomDataService().updateCustomBoxType( customboxtype);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+customboxtype.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+customboxtype.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkCustomBoxTypes(CustomBoxType customboxtype, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = customboxtype instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)customboxtype).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)customboxtype).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockCustomBoxTypes(customboxtype, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateCustomBoxTypes(CustomBoxType customboxtype, HttpServletRequest req) throws Exception{
		if(customboxtype instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)customboxtype, false, getUserId(req));
		}
		if (isTimeoutReached(customboxtype)) {
			checkCustomBoxTypes(customboxtype, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(customboxtype, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(CustomBoxType customboxtype){
		if (customboxtype instanceof LockableObject) {
			LockableObject lock = (LockableObject)customboxtype;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(CustomBoxType customboxtype, HttpServletRequest req){
		if (customboxtype instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)customboxtype;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
