/**
 ********************************************************************************
 *** EditFeatureAction.java                                                   ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asfeature.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.asfeature.bean.EditFeatureFB;
import net.anotheria.anosite.gen.asfeature.data.Feature;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.asg.util.bean.LinkToMeBean;
import net.anotheria.anosite.gen.aswebdata.data.Pagex;
import net.anotheria.anosite.gen.aswebdata.data.Box;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.AccessOperation;

public class EditFeatureAction extends ShowFeaturesAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateEditAction

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateEditActionMethod

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		EditFeatureFB form = new EditFeatureFB() ;
		Feature feature = getASFeatureService().getFeature(id);
		checkFeatures(feature, req);
		if(feature instanceof LockableObject && !((LockableObject)feature).isLocked() && isAutoLockingEnabled())
			lockFeatures(feature, req);
		form.setId(feature.getId());
		form.setName(feature.getName());
		form.setEnabled(feature.getEnabled());
		form.setActiveInProduction(feature.getActiveInProduction());
		form.setObsolete(feature.getObsolete());
		// guards is a table, storing size only
		form.setGuards(feature.getGuardsSize());
		form.setAccessOperation(feature.getAccessOperation());
		form.setDescription(feature.getDescription());
		form.setLocked(((LockableObject)feature).isLocked());
		form.setLockerId(((LockableObject)feature).getLockerId());
		form.setLockingTime(net.anotheria.util.NumberUtils.makeISO8601TimestampString(((LockableObject)feature).getLockingTime()) + " automatic unlock expected AT : " + net.anotheria.util.NumberUtils.makeISO8601TimestampString(((LockableObject)feature).getLockingTime() + getLockingTimeout()));


		//link accessOperation to AnoAccessConfiguration.AccessOperation
		List<AccessOperation> accessoperations = getAnoAccessConfigurationService().getAccessOperations();
		List<LabelValueBean> accessoperationsValues = new ArrayList<LabelValueBean>(accessoperations.size()+1);
		accessoperationsValues.add(new LabelValueBean("", "-----"));
		for (net.anotheria.anosite.gen.anoaccessconfiguration.data.AccessOperation accessoperationTemp : accessoperations){
			LabelValueBean bean = new LabelValueBean(accessoperationTemp.getId(), accessoperationTemp.getName() + " [" + accessoperationTemp.getId() + "]" );
			accessoperationsValues.add(bean);
		}
		form.setAccessOperationCollection(accessoperationsValues);
		try{
			form.setAccessOperationCurrentValue(getAnoAccessConfigurationService().getAccessOperation(feature.getAccessOperation()).getName());
		}catch(Exception e){
			form.setAccessOperationCurrentValue("none");
			form.setAccessOperationIdOfCurrentValue("none");
		}
		addBeanToRequest(req, "objectId" , feature.getId());
		addBeanToRequest(req, "EditASFeatureFeatureForm" , form);
		addBeanToRequest(req, "objectInfoString" , feature.getObjectInfo().toString());
		addBeanToRequest(req, "apply.label.prefix", "Apply");
		addBeanToRequest(req, "save.label.prefix", "Save");

		addFieldExplanations(req, feature);


		// Generating back link handling...
		List<LinkToMeBean> linksToMe = findLinksToCurrentDocument(feature.getId());
		if (linksToMe.size()>0)
			req.setAttribute("linksToMe", linksToMe);
		return mapping.success();
	}

	private List<LinkToMeBean> findLinksToCurrentDocument(String documentId){
		List<LinkToMeBean> ret = new ArrayList<LinkToMeBean>();
		try{
			ret.addAll(findLinkToCurrentDocumentInASWebDataPagexFeature(documentId));
		}catch(Exception ignored){
		}
		try{
			ret.addAll(findLinkToCurrentDocumentInASWebDataBoxFeature(documentId));
		}catch(Exception ignored){
		}
		return ret;
	}
	private List<LinkToMeBean> findLinkToCurrentDocumentInASWebDataPagexFeature(String documentId) throws net.anotheria.anosite.gen.aswebdata.service.ASWebDataServiceException{
		List<LinkToMeBean> ret = new ArrayList<LinkToMeBean>();
		QueryProperty p = new QueryProperty(Pagex.LINK_PROP_FEATURE, documentId);
		// temporarly - replacy with query property
		List<Pagex> list = getASWebDataService().getPagexsByProperty(p.getName(), p.getValue());
		for (Pagex doc : list ){
			ret.add(new LinkToMeBean(doc, "feature"));
		}
		return ret;
	}
	private List<LinkToMeBean> findLinkToCurrentDocumentInASWebDataBoxFeature(String documentId) throws net.anotheria.anosite.gen.aswebdata.service.ASWebDataServiceException{
		List<LinkToMeBean> ret = new ArrayList<LinkToMeBean>();
		QueryProperty p = new QueryProperty(Box.LINK_PROP_FEATURE, documentId);
		// temporarly - replacy with query property
		List<Box> list = getASWebDataService().getBoxsByProperty(p.getName(), p.getValue());
		for (Box doc : list ){
			ret.add(new LinkToMeBean(doc, "feature"));
		}
		return ret;
	}
}
