/**
 ********************************************************************************
 *** ExportFeaturesAction.java                                                ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asfeature.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.xml.XMLNode;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.asfeature.data.Feature;
import net.anotheria.anosite.gen.asfeature.data.FeatureSortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;
import net.anotheria.anosite.gen.asfeature.bean.FeatureListItemBeanSortType;

public class ExportFeaturesAction extends BaseFeatureAction{

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"Feature";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"Feature";
	private static final List<String> ITEMS_ON_PAGE_SELECTOR = java.util.Arrays.asList(new String[]{"5","10","20","25","50","100","500","1000"});
	private static final Logger log = LoggerFactory.getLogger(ExportFeaturesAction.class);
	private Sorter<Feature> sorter;

	private DocumentFilter nameFilterAZ;

	public ExportFeaturesAction(){
		super();
		sorter = new QuickSorter<Feature>();
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		int sortMethod = FeatureListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = FeatureListItemBeanSortType.ASC;
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = FeatureListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			sortOrder = getStringParameter(req, PARAM_SORT_ORDER).equals("ASC") ? 
				FeatureListItemBeanSortType.ASC : FeatureListItemBeanSortType.DESC;
		}catch(Exception ignored){}

		FeatureListItemBeanSortType sessionSortType  = null;
		FeatureSortType sortType = null;
		if (sortParamSet){
			sessionSortType = new FeatureListItemBeanSortType(sortMethod, sortOrder);
			sortType = new FeatureSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sessionSortType);
		}else{
			sessionSortType = (FeatureListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			sortType = sessionSortType == null ? new FeatureSortType(sortMethod, sortOrder) : new FeatureSortType(sessionSortType.getSortBy(), sessionSortType.getSortOrder());
			sessionSortType = sessionSortType == null ? new FeatureListItemBeanSortType(sortMethod, sortOrder) : sessionSortType;
		}
		req.setAttribute("currentSortCode", sessionSortType.getMethodAndOrderCode());

		List<Feature> _unfiltered_features = getASFeatureService().getFeatures();
		List<Feature> features = new ArrayList<Feature>();
		for (Feature element : _unfiltered_features ){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass( element, "name", filterParameter0));
			if (mayPass)
				features.add(element);
		}
		features = sorter.sort(features, sortType);

		addBeanToRequest(req, "features", features);

		XMLNode beans = getASFeatureService().exportFeaturesToXML(features);


		/**
		 * for XML node - page
		 */
		addBeanToRequest(req, "featuresXML", beans);
		/**
		 * for CSV - page
		 */
		addBeanToRequest(req, "featuresCSV", features);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer(""));
		return mapping.success();
	}

}
