/**
 ********************************************************************************
 *** BaseGenericActionDefAction.java                                          ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asgenericaction.action;

import net.anotheria.anosite.gen.shared.action.BaseActionsAction;
import javax.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.asgenericaction.data.GenericActionDef;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseGenericActionDefAction extends BaseActionsAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "GenericActions";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASGenericAction";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "GenericActionDef";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, GenericActionDef genericactiondef) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASGenericAction.GenericActionDef").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASGenericAction.GenericActionDef", genericactiondef, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASGenericAction.GenericActionDef", genericactiondef, "clazz");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.clazz", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockGenericActionDefs(GenericActionDef genericactiondef, HttpServletRequest req) throws Exception{
		if(genericactiondef instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)genericactiondef;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASGenericActionService().updateGenericActionDef( genericactiondef);
			logger.info("Lock-OPERATION, document with id : ["+genericactiondef.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockGenericActionDefs(GenericActionDef genericactiondef, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(genericactiondef instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)genericactiondef;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASGenericActionService().updateGenericActionDef( genericactiondef);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+genericactiondef.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+genericactiondef.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkGenericActionDefs(GenericActionDef genericactiondef, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = genericactiondef instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)genericactiondef).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)genericactiondef).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockGenericActionDefs(genericactiondef, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateGenericActionDefs(GenericActionDef genericactiondef, HttpServletRequest req) throws Exception{
		if(genericactiondef instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)genericactiondef, false, getUserId(req));
		}
		if (isTimeoutReached(genericactiondef)) {
			checkGenericActionDefs(genericactiondef, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(genericactiondef, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(GenericActionDef genericactiondef){
		if (genericactiondef instanceof LockableObject) {
			LockableObject lock = (LockableObject)genericactiondef;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(GenericActionDef genericactiondef, HttpServletRequest req){
		if (genericactiondef instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)genericactiondef;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
