/**
 ********************************************************************************
 *** BaseGenericBoxHandlerDefAction.java                                      ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asgenericdata.action;

import net.anotheria.anosite.gen.shared.action.BaseDefinitionsAction;
import javax.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.asgenericdata.data.GenericBoxHandlerDef;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseGenericBoxHandlerDefAction extends BaseDefinitionsAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Generic BoxHandler";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASGenericData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "GenericBoxHandlerDef";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, GenericBoxHandlerDef genericboxhandlerdef) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASGenericData.GenericBoxHandlerDef").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASGenericData.GenericBoxHandlerDef", genericboxhandlerdef, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASGenericData.GenericBoxHandlerDef", genericboxhandlerdef, "clazz");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.clazz", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockGenericBoxHandlerDefs(GenericBoxHandlerDef genericboxhandlerdef, HttpServletRequest req) throws Exception{
		if(genericboxhandlerdef instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)genericboxhandlerdef;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASGenericDataService().updateGenericBoxHandlerDef( genericboxhandlerdef);
			logger.info("Lock-OPERATION, document with id : ["+genericboxhandlerdef.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockGenericBoxHandlerDefs(GenericBoxHandlerDef genericboxhandlerdef, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(genericboxhandlerdef instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)genericboxhandlerdef;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASGenericDataService().updateGenericBoxHandlerDef( genericboxhandlerdef);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+genericboxhandlerdef.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+genericboxhandlerdef.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkGenericBoxHandlerDefs(GenericBoxHandlerDef genericboxhandlerdef, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = genericboxhandlerdef instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)genericboxhandlerdef).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)genericboxhandlerdef).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockGenericBoxHandlerDefs(genericboxhandlerdef, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateGenericBoxHandlerDefs(GenericBoxHandlerDef genericboxhandlerdef, HttpServletRequest req) throws Exception{
		if(genericboxhandlerdef instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)genericboxhandlerdef, false, getUserId(req));
		}
		if (isTimeoutReached(genericboxhandlerdef)) {
			checkGenericBoxHandlerDefs(genericboxhandlerdef, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(genericboxhandlerdef, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(GenericBoxHandlerDef genericboxhandlerdef){
		if (genericboxhandlerdef instanceof LockableObject) {
			LockableObject lock = (LockableObject)genericboxhandlerdef;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(GenericBoxHandlerDef genericboxhandlerdef, HttpServletRequest req){
		if (genericboxhandlerdef instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)genericboxhandlerdef;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
