/**
 ********************************************************************************
 *** ExportPageLayoutsAction.java                                             ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aslayoutdata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.xml.XMLNode;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.aslayoutdata.data.PageLayout;
import net.anotheria.anosite.gen.aslayoutdata.data.PageLayoutSortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;
import net.anotheria.anosite.gen.aslayoutdata.bean.PageLayoutListItemBeanSortType;

public class ExportPageLayoutsAction extends BasePageLayoutAction{

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"PageLayout";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"PageLayout";
	private static final List<String> ITEMS_ON_PAGE_SELECTOR = java.util.Arrays.asList(new String[]{"5","10","20","25","50","100","500","1000"});
	private static final Logger log = LoggerFactory.getLogger(ExportPageLayoutsAction.class);
	private Sorter<PageLayout> sorter;

	private DocumentFilter nameFilterAZ;

	public ExportPageLayoutsAction(){
		super();
		sorter = new QuickSorter<PageLayout>();
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		int sortMethod = PageLayoutListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = PageLayoutListItemBeanSortType.ASC;
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = PageLayoutListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			sortOrder = getStringParameter(req, PARAM_SORT_ORDER).equals("ASC") ? 
				PageLayoutListItemBeanSortType.ASC : PageLayoutListItemBeanSortType.DESC;
		}catch(Exception ignored){}

		PageLayoutListItemBeanSortType sessionSortType  = null;
		PageLayoutSortType sortType = null;
		if (sortParamSet){
			sessionSortType = new PageLayoutListItemBeanSortType(sortMethod, sortOrder);
			sortType = new PageLayoutSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sessionSortType);
		}else{
			sessionSortType = (PageLayoutListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			sortType = sessionSortType == null ? new PageLayoutSortType(sortMethod, sortOrder) : new PageLayoutSortType(sessionSortType.getSortBy(), sessionSortType.getSortOrder());
			sessionSortType = sessionSortType == null ? new PageLayoutListItemBeanSortType(sortMethod, sortOrder) : sessionSortType;
		}
		req.setAttribute("currentSortCode", sessionSortType.getMethodAndOrderCode());

		List<PageLayout> _unfiltered_pagelayouts = getASLayoutDataService().getPageLayouts();
		List<PageLayout> pagelayouts = new ArrayList<PageLayout>();
		for (PageLayout element : _unfiltered_pagelayouts ){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass( element, "name", filterParameter0));
			if (mayPass)
				pagelayouts.add(element);
		}
		pagelayouts = sorter.sort(pagelayouts, sortType);

		addBeanToRequest(req, "pagelayouts", pagelayouts);

		XMLNode beans = getASLayoutDataService().exportPageLayoutsToXML(pagelayouts);


		/**
		 * for XML node - page
		 */
		addBeanToRequest(req, "pagelayoutsXML", beans);
		/**
		 * for CSV - page
		 */
		addBeanToRequest(req, "pagelayoutsCSV", pagelayouts);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer(""));
		return mapping.success();
	}

}
