/**
 ********************************************************************************
 *** ShowPageLayoutsAction.java                                               ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aslayoutdata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.aslayoutdata.data.PageLayout;
import net.anotheria.anosite.gen.aslayoutdata.bean.PageLayoutListItemBean;
import net.anotheria.asg.data.LockableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.aslayoutdata.bean.PageLayoutListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;

public class ShowPageLayoutsAction extends BasePageLayoutAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"PageLayout";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"PageLayout";
	private static Logger log = LoggerFactory.getLogger(ShowPageLayoutsAction.class);
	private Sorter<PageLayoutListItemBean> sorter;

	private IAttributeDecorator idDecorator;
	private IAttributeDecorator nameDecorator;
	private IAttributeDecorator layoutpageDecorator;
	private IAttributeDecorator styleDecorator;

	private DocumentFilter nameFilterAZ;

	public ShowPageLayoutsAction(){
		sorter = new QuickSorter<PageLayoutListItemBean>();
		try{ 
			idDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.IDItoADecorator").newInstance();
			nameDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
			layoutpageDecorator = (IAttributeDecorator)Class.forName("net.anotheria.asg.util.decorators.EditLinkDecorator").newInstance();
			styleDecorator = (IAttributeDecorator)Class.forName("net.anotheria.anosite.decorator.LinkTargetNameDecorator").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate decorator:", e);
		}
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		int sortMethod = PageLayoutListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = PageLayoutListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		PageLayoutListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new PageLayoutListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (PageLayoutListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new PageLayoutListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<PageLayout> _unfiltered_pagelayouts = getASLayoutDataService().getPageLayouts();
		List<PageLayout> pagelayouts = new ArrayList<PageLayout>();
		for (int i=0; i<_unfiltered_pagelayouts.size(); i++){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass(_unfiltered_pagelayouts.get(i), "name", filterParameter0));
			if (mayPass)
				pagelayouts.add(_unfiltered_pagelayouts.get(i));
		}
		List<PageLayoutListItemBean> beans = new ArrayList<PageLayoutListItemBean>(pagelayouts.size());
		for (PageLayout pagelayout : pagelayouts){
			checkPageLayouts(pagelayout, req);
			PageLayoutListItemBean bean = makePageLayoutListItemBean(pagelayout);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "pagelayouts", beans);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer("name"));
		return mapping.success();
	}

	protected PageLayoutListItemBean makePageLayoutListItemBean(PageLayout pagelayout) {
		PageLayoutListItemBean bean = new PageLayoutListItemBean();
		bean.setPlainId(pagelayout.getId());
		bean.setIdForSorting(pagelayout.getId());
		bean.setId(idDecorator.decorate(pagelayout, "id", "3"));
		bean.setNameForSorting(pagelayout.getName());
		bean.setName(nameDecorator.decorate(pagelayout, "name", "null"));
		bean.setLayoutpageForSorting(pagelayout.getLayoutpage());
		bean.setLayoutpage(layoutpageDecorator.decorate(pagelayout, "layoutpage", "null"));
		bean.setStyleForSorting(pagelayout.getStyle());
		bean.setStyle(styleDecorator.decorate(pagelayout, "style", "null"));
		bean.setLocked(((LockableObject)pagelayout).isLocked());
		bean.setLockerId(((LockableObject)pagelayout).getLockerId());
		bean.setLockingTime(NumberUtils.makeISO8601TimestampString(((LockableObject)pagelayout).getLockingTime()) + " till: " + NumberUtils.makeISO8601TimestampString(((LockableObject)pagelayout).getLockingTime() + getLockingTimeout()));
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(pagelayout.getLastUpdateTimestamp()));
		return bean;
	}
}
