/**
 ********************************************************************************
 *** BaseMailTemplateAction.java                                              ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.action;

import net.anotheria.anosite.gen.shared.action.BaseResourcesAction;
import javax.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.asresourcedata.data.MailTemplate;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseMailTemplateAction extends BaseResourcesAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Mail Templates";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASResourceData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "MailTemplate";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, MailTemplate mailtemplate) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASResourceData.MailTemplate").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.MailTemplate", mailtemplate, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.MailTemplate", mailtemplate, "sender");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.sender", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.MailTemplate", mailtemplate, "senderName");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.senderName", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.MailTemplate", mailtemplate, "subject");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.subject", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.MailTemplate", mailtemplate, "message");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.message", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.MailTemplate", mailtemplate, "mjml");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.mjml", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.MailTemplate", mailtemplate, "plainMessage");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.plainMessage", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.MailTemplate", mailtemplate, "localizations");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.localizations", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockMailTemplates(MailTemplate mailtemplate, HttpServletRequest req) throws Exception{
		if(mailtemplate instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)mailtemplate;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASResourceDataService().updateMailTemplate( mailtemplate);
			logger.info("Lock-OPERATION, document with id : ["+mailtemplate.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockMailTemplates(MailTemplate mailtemplate, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(mailtemplate instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)mailtemplate;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASResourceDataService().updateMailTemplate( mailtemplate);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+mailtemplate.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+mailtemplate.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkMailTemplates(MailTemplate mailtemplate, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = mailtemplate instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)mailtemplate).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)mailtemplate).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockMailTemplates(mailtemplate, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateMailTemplates(MailTemplate mailtemplate, HttpServletRequest req) throws Exception{
		if(mailtemplate instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)mailtemplate, false, getUserId(req));
		}
		if (isTimeoutReached(mailtemplate)) {
			checkMailTemplates(mailtemplate, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(mailtemplate, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(MailTemplate mailtemplate){
		if (mailtemplate instanceof LockableObject) {
			LockableObject lock = (LockableObject)mailtemplate;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(MailTemplate mailtemplate, HttpServletRequest req){
		if (mailtemplate instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)mailtemplate;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
