/**
 ********************************************************************************
 *** BaseTextResourceAction.java                                              ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.action;

import net.anotheria.anosite.gen.shared.action.BaseResourcesAction;
import javax.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.asresourcedata.data.TextResource;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseTextResourceAction extends BaseResourcesAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Text";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASResourceData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "TextResource";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, TextResource textresource) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASResourceData.TextResource").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.TextResource", textresource, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASResourceData.TextResource", textresource, "value");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.value", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockTextResources(TextResource textresource, HttpServletRequest req) throws Exception{
		if(textresource instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)textresource;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASResourceDataService().updateTextResource( textresource);
			logger.info("Lock-OPERATION, document with id : ["+textresource.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockTextResources(TextResource textresource, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(textresource instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)textresource;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASResourceDataService().updateTextResource( textresource);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+textresource.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+textresource.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkTextResources(TextResource textresource, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = textresource instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)textresource).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)textresource).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockTextResources(textresource, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateTextResources(TextResource textresource, HttpServletRequest req) throws Exception{
		if(textresource instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)textresource, false, getUserId(req));
		}
		if (isTimeoutReached(textresource)) {
			checkTextResources(textresource, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(textresource, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(TextResource textresource){
		if (textresource instanceof LockableObject) {
			LockableObject lock = (LockableObject)textresource;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(TextResource textresource, HttpServletRequest req){
		if (textresource instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)textresource;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
