/**
 ********************************************************************************
 *** ExportPdfTemplatesAction.java                                            ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.xml.XMLNode;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.asresourcedata.data.PdfTemplate;
import net.anotheria.anosite.gen.asresourcedata.data.PdfTemplateSortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;
import net.anotheria.anosite.gen.asresourcedata.bean.PdfTemplateListItemBeanSortType;

public class ExportPdfTemplatesAction extends BasePdfTemplateAction{

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"PdfTemplate";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"PdfTemplate";
	private static final List<String> ITEMS_ON_PAGE_SELECTOR = java.util.Arrays.asList(new String[]{"5","10","20","25","50","100","500","1000"});
	private static final Logger log = LoggerFactory.getLogger(ExportPdfTemplatesAction.class);
	private Sorter<PdfTemplate> sorter;

	private DocumentFilter nameFilterAZ;
	private DocumentFilter AnyFilterMissingTranslation;

	public ExportPdfTemplatesAction(){
		super();
		sorter = new QuickSorter<PdfTemplate>();
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
			AnyFilterMissingTranslation = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.MissingAnyTranslationFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		String filterParameter1 = "";
		try{ 
			filterParameter1 = getStringParameter(req, "pFilter1");
			addBeanToSession(req, SA_FILTER+"1", filterParameter1);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter1 = (String)getBeanFromSession(req, SA_FILTER+"1");
			if (filterParameter1==null)
				filterParameter1 = "";
		}
		req.setAttribute("currentFilterParameter1", filterParameter1);

		int sortMethod = PdfTemplateListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = PdfTemplateListItemBeanSortType.ASC;
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = PdfTemplateListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			sortOrder = getStringParameter(req, PARAM_SORT_ORDER).equals("ASC") ? 
				PdfTemplateListItemBeanSortType.ASC : PdfTemplateListItemBeanSortType.DESC;
		}catch(Exception ignored){}

		PdfTemplateListItemBeanSortType sessionSortType  = null;
		PdfTemplateSortType sortType = null;
		if (sortParamSet){
			sessionSortType = new PdfTemplateListItemBeanSortType(sortMethod, sortOrder);
			sortType = new PdfTemplateSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sessionSortType);
		}else{
			sessionSortType = (PdfTemplateListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			sortType = sessionSortType == null ? new PdfTemplateSortType(sortMethod, sortOrder) : new PdfTemplateSortType(sessionSortType.getSortBy(), sessionSortType.getSortOrder());
			sessionSortType = sessionSortType == null ? new PdfTemplateListItemBeanSortType(sortMethod, sortOrder) : sessionSortType;
		}
		req.setAttribute("currentSortCode", sessionSortType.getMethodAndOrderCode());

		List<PdfTemplate> _unfiltered_pdftemplates = getASResourceDataService().getPdfTemplates();
		List<PdfTemplate> pdftemplates = new ArrayList<PdfTemplate>();
		for (PdfTemplate element : _unfiltered_pdftemplates ){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass( element, "name", filterParameter0));
			mayPass = mayPass && (AnyFilterMissingTranslation.mayPass( element, "Any", filterParameter1));
			if (mayPass)
				pdftemplates.add(element);
		}
		pdftemplates = sorter.sort(pdftemplates, sortType);

		addBeanToRequest(req, "pdftemplates", pdftemplates);

		XMLNode beans = getASResourceDataService().exportPdfTemplatesToXML(pdftemplates);


		/**
		 * for XML node - page
		 */
		addBeanToRequest(req, "pdftemplatesXML", beans);
		/**
		 * for CSV - page
		 */
		addBeanToRequest(req, "pdftemplatesCSV", pdftemplates);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer(""));
		addBeanToRequest(req, "AnyFilterMissingTranslation", AnyFilterMissingTranslation.getTriggerer(""));
		return mapping.success();
	}

}
