/**
 ********************************************************************************
 *** MultiOpDialogFileLinksAction.java                                        ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.action;

import net.anotheria.util.NumberUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.asresourcedata.data.FileLinkFactory;
import net.anotheria.anosite.gen.asresourcedata.data.FileLink;
import net.anotheria.anosite.gen.asresourcedata.bean.EditFileLinkFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import net.anotheria.webutils.filehandling.actions.FileStorage;
import net.anotheria.webutils.filehandling.beans.TemporaryFileHolder;
import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;
import net.anotheria.util.StringUtils;
import org.apache.commons.lang.WordUtils;

public class MultiOpDialogFileLinksAction extends BaseFileLinkAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("asresourcedataFileLinkDelete"))
			return asresourcedataFileLinkDelete(mapping, req, res);
		if (path.equals("asresourcedataFileLinkDuplicate"))
			return asresourcedataFileLinkDuplicate(mapping, req, res);
		if (path.equals("asresourcedataFileLinkUpdate"))
			return asresourcedataFileLinkUpdate(mapping, req, res);
		if (path.equals("asresourcedataFileLinkClose"))
			return asresourcedataFileLinkClose(mapping, req, res);
		if (path.equals("asresourcedataFileLinkLock"))
			return asresourcedataFileLinkLock(mapping, req, res);
		if (path.equals("asresourcedataFileLinkUnLock"))
			return asresourcedataFileLinkUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand asresourcedataFileLinkDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			FileLink filelinkCurr = getASResourceDataService().getFileLink(id);
			if (filelinkCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)filelinkCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASResourceDataService().deleteFileLink(id);
			FileStorage.removeFilePermanently( filelinkCurr.getFile() );
		}
		res.sendRedirect("asresourcedataFileLinkShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand asresourcedataFileLinkDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		FileLink filelinkSrc = getASResourceDataService().getFileLink(id);
		FileLink filelinkDest = FileLinkFactory.createFileLink(filelinkSrc);

		filelinkDest.setFile(FileStorage.cloneFilePermanently( filelinkDest.getFile() ));

		FileLink filelinkCreated = getASResourceDataService().createFileLink(filelinkDest);
		res.sendRedirect("asresourcedataFileLinkEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+filelinkCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand asresourcedataFileLinkUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditFileLinkFB form = new EditFileLinkFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		FileLink filelink = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		filelink = (FileLink)getASResourceDataService().getFileLink(form.getId()).clone();
	}else{
		filelink = FileLinkFactory.createFileLink();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	filelink.setName(form.getName());
	filelink.setTitle(form.getTitle());
	//handle image
	TemporaryFileHolder holder_file = FileStorage.getTemporaryFile(req,"file");
	if (holder_file!=null && holder_file.getData()!=null){
		FileStorage.removeFilePermanently( filelink.getFile() );
		FileStorage.storeFilePermanently(req, holder_file.getFileName(),"file");
		filelink.setFile(holder_file.getFileName());
		FileStorage.removeTemporaryFile(req,"file");
	}

	// delete image method start
	String fieldName = req.getParameter("fieldName");
	String fileName = req.getParameter("fileName");

	if (!StringUtils.isEmpty(fieldName) && !StringUtils.isEmpty(fileName)) {
		String setMethodName = "set"+WordUtils.capitalize(fieldName);
		Class<?> c = filelink.getClass();
		try{
			Method m = c.getDeclaredMethod(setMethodName, new Class[]{String.class});
			m.invoke(filelink, new Object[]{""});
			FileStorage.removeFilePermanently(fileName);
		}catch (NoSuchMethodException e){
			e.printStackTrace();
		}catch (InvocationTargetException ignored) {
			ignored.printStackTrace();
		}
	}
	// delete image method end


	FileLink updatedCopy = null;
	if (create){
		updatedCopy = getASResourceDataService().createFileLink(filelink);
	}else{
		canUpdateFileLinks(filelink, req);
		checkFileLinks(filelink, req);
		updatedCopy = getASResourceDataService().updateFileLink(filelink);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("asresourcedataFileLinkEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(filelink, req);
		res.sendRedirect("asresourcedataFileLinkShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(FileLink filelink, HttpServletRequest req) throws Exception{
	if(((LockableObject)filelink).isLocked())
		unLockFileLinks(filelink, req, false);
}

public ActionCommand asresourcedataFileLinkLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	FileLink filelinkCurr = id != null && !id.equals("") ? getASResourceDataService().getFileLink(id) : null;
	if(filelinkCurr != null && filelinkCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)filelinkCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockFileLinks(filelinkCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, filelinkCurr));
	return null;
}

public ActionCommand asresourcedataFileLinkUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	FileLink filelinkCurr = id != null && !id.equals("") ? getASResourceDataService().getFileLink(id) : null;
	if(filelinkCurr != null && filelinkCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)filelinkCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockFileLinks(filelinkCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, filelinkCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, FileLink item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "asresourcedataFileLinkShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "asresourcedataFileLinkEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "asresourcedataFileLinkShow?ts="+System.currentTimeMillis();
}

public ActionCommand asresourcedataFileLinkClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	FileLink filelinkCurr = id != null && !id.equals("") ? getASResourceDataService().getFileLink(id) : null;
	if(filelinkCurr != null && filelinkCurr instanceof LockableObject && ((LockableObject)filelinkCurr).isLocked()) 
		unLockFileLinks(filelinkCurr, req, false);
	res.sendRedirect("asresourcedataFileLinkShow?ts="+System.currentTimeMillis());
	return null;
}

}
