/**
 ********************************************************************************
 *** MultiOpDialogTextResourcesAction.java                                    ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.action;

import net.anotheria.util.NumberUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.asresourcedata.data.TextResourceFactory;
import net.anotheria.anosite.gen.asresourcedata.data.TextResource;
import net.anotheria.anosite.gen.asresourcedata.bean.EditTextResourceFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import net.anotheria.asg.data.MultilingualObject;

public class MultiOpDialogTextResourcesAction extends BaseTextResourceAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("asresourcedataTextResourceDelete"))
			return asresourcedataTextResourceDelete(mapping, req, res);
		if (path.equals("asresourcedataTextResourceDuplicate"))
			return asresourcedataTextResourceDuplicate(mapping, req, res);
		if (path.equals("asresourcedataTextResourceUpdate"))
			return asresourcedataTextResourceUpdate(mapping, req, res);
		if (path.equals("asresourcedataTextResourceClose"))
			return asresourcedataTextResourceClose(mapping, req, res);
		if (path.equals("asresourcedataTextResourceCopyLang"))
			return asresourcedataTextResourceCopyLang(mapping, req, res);
		if (path.equals("asresourcedataTextResourceSwitchMultilang"))
			return asresourcedataTextResourceSwitchMultilang(mapping, req, res);
		if (path.equals("asresourcedataTextResourceLock"))
			return asresourcedataTextResourceLock(mapping, req, res);
		if (path.equals("asresourcedataTextResourceUnLock"))
			return asresourcedataTextResourceUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand asresourcedataTextResourceDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			TextResource textresourceCurr = getASResourceDataService().getTextResource(id);
			if (textresourceCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)textresourceCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASResourceDataService().deleteTextResource(id);
		}
		res.sendRedirect("asresourcedataTextResourceShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand asresourcedataTextResourceDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		TextResource textresourceSrc = getASResourceDataService().getTextResource(id);
		TextResource textresourceDest = TextResourceFactory.createTextResource(textresourceSrc);


		TextResource textresourceCreated = getASResourceDataService().createTextResource(textresourceDest);
		res.sendRedirect("asresourcedataTextResourceEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+textresourceCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand asresourcedataTextResourceUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditTextResourceFB form = new EditTextResourceFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		TextResource textresource = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		textresource = (TextResource)getASResourceDataService().getTextResource(form.getId()).clone();
	}else{
		textresource = TextResourceFactory.createTextResource();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	textresource.setName(form.getName());
	textresource.setValueEN(form.getValueEN());

	TextResource updatedCopy = null;
	if (create){
		updatedCopy = getASResourceDataService().createTextResource(textresource);
	}else{
		canUpdateTextResources(textresource, req);
		checkTextResources(textresource, req);
		updatedCopy = getASResourceDataService().updateTextResource(textresource);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("asresourcedataTextResourceEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(textresource, req);
		res.sendRedirect("asresourcedataTextResourceShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(TextResource textresource, HttpServletRequest req) throws Exception{
	if(((LockableObject)textresource).isLocked())
		unLockTextResources(textresource, req, false);
}

public ActionCommand asresourcedataTextResourceCopyLang(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String sourceLanguage = req.getParameter("pSrcLang");
	if (sourceLanguage==null || sourceLanguage.length()==0)
		throw new RuntimeException("No source language");

	String destLanguage = req.getParameter("pDestLang");
	if (destLanguage==null || destLanguage.length()==0)
		throw new RuntimeException("No destination language");

	String id = getStringParameter(req, PARAM_ID);
	TextResource textresource = getASResourceDataService().getTextResource(id);
	canUpdateTextResources(textresource, req);
	checkTextResources(textresource, req);
	textresource.copyLANG2LANG(sourceLanguage, destLanguage);
	getASResourceDataService().updateTextResource(textresource);
	res.sendRedirect("asresourcedataTextResourceEdit?ts="+System.currentTimeMillis()+"&pId="+id);
	return null;
}

public ActionCommand asresourcedataTextResourceSwitchMultilang(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	String value = getStringParameter(req, "value");
	TextResource textresource = getASResourceDataService().getTextResource(id);
	canUpdateTextResources(textresource, req);
	checkTextResources(textresource, req);
	((MultilingualObject)textresource).setMultilingualDisabledInstance(Boolean.valueOf(value));
	getASResourceDataService().updateTextResource(textresource);
	res.sendRedirect("asresourcedataTextResourceEdit?ts="+System.currentTimeMillis()+"&pId="+id);
	return null;
}

public ActionCommand asresourcedataTextResourceLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	TextResource textresourceCurr = id != null && !id.equals("") ? getASResourceDataService().getTextResource(id) : null;
	if(textresourceCurr != null && textresourceCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)textresourceCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockTextResources(textresourceCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, textresourceCurr));
	return null;
}

public ActionCommand asresourcedataTextResourceUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	TextResource textresourceCurr = id != null && !id.equals("") ? getASResourceDataService().getTextResource(id) : null;
	if(textresourceCurr != null && textresourceCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)textresourceCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockTextResources(textresourceCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, textresourceCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, TextResource item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "asresourcedataTextResourceShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "asresourcedataTextResourceEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "asresourcedataTextResourceShow?ts="+System.currentTimeMillis();
}

public ActionCommand asresourcedataTextResourceClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	TextResource textresourceCurr = id != null && !id.equals("") ? getASResourceDataService().getTextResource(id) : null;
	if(textresourceCurr != null && textresourceCurr instanceof LockableObject && ((LockableObject)textresourceCurr).isLocked()) 
		unLockTextResources(textresourceCurr, req, false);
	res.sendRedirect("asresourcedataTextResourceShow?ts="+System.currentTimeMillis());
	return null;
}

}
