/**
 ********************************************************************************
 *** BaseFilteredIPAction.java                                                ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.assiteconfig.action;

import net.anotheria.anosite.gen.shared.action.BaseSiteConfigAction;
import javax.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.assiteconfig.data.FilteredIP;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseFilteredIPAction extends BaseSiteConfigAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Filtered IP";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASSiteConfig";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "FilteredIP";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, FilteredIP filteredip) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASSiteConfig.FilteredIP").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteConfig.FilteredIP", filteredip, "ipAddress");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.ipAddress", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteConfig.FilteredIP", filteredip, "mask");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.mask", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASSiteConfig.FilteredIP", filteredip, "allowance");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.allowance", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockFilteredIPs(FilteredIP filteredip, HttpServletRequest req) throws Exception{
		if(filteredip instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)filteredip;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASSiteConfigService().updateFilteredIP( filteredip);
			logger.info("Lock-OPERATION, document with id : ["+filteredip.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockFilteredIPs(FilteredIP filteredip, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(filteredip instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)filteredip;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASSiteConfigService().updateFilteredIP( filteredip);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+filteredip.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+filteredip.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkFilteredIPs(FilteredIP filteredip, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = filteredip instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)filteredip).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)filteredip).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockFilteredIPs(filteredip, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateFilteredIPs(FilteredIP filteredip, HttpServletRequest req) throws Exception{
		if(filteredip instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)filteredip, false, getUserId(req));
		}
		if (isTimeoutReached(filteredip)) {
			checkFilteredIPs(filteredip, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(filteredip, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(FilteredIP filteredip){
		if (filteredip instanceof LockableObject) {
			LockableObject lock = (LockableObject)filteredip;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(FilteredIP filteredip, HttpServletRequest req){
		if (filteredip instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)filteredip;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
